% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformatDOY.R
\name{reformatDOY}
\alias{reformatDOY}
\title{Reformat MODIS "composite_day_of_the_year" SDS}
\usage{
reformatDOY(x, cores = 1L, ...)
}
\arguments{
\item{x}{\code{character} or \code{Raster*}. MODIS 
"composite_day_of_the_year" layer(s).}

\item{cores}{\code{integer}. Number of cores for parallel processing.}

\item{...}{Additional arguments passed to \code{\link{extractDate}}.}
}
\value{
A \code{Raster*} object.
}
\description{
In order to create custom temporal aggregation levels (e.g., half-monthly, 
monthly) from native 16-day MODIS composites, a convenient representation of 
the pixel-wise acquisition date is urgently required. Since the MODIS 
"composite_day_of_the_year" SDS merely includes the day of the year (DOY), 
but not the year itself, this function creates complete date information from 
both the respective MODIS layer name and the pixel-wise DOY information.
}
\examples{
\dontrun{
runGdal("MOD13Q1", collection = getCollection("MOD13Q1", forceCheck = TRUE),
        begin = "2000353", end = "2000366", extent = "Luxembourg", 
        job = "reformatDOY", SDSstring = "000000000010")
        
fls <- list.files(paste0(getOption("MODIS_outDirPath"), "/reformatDOY"), 
                  pattern = "day_of_the_year.tif$", full.names = TRUE)
                  
## raw doy
raw <- raster(fls)
unique(raw[])

## reformatted dates
rfm <- reformatDOY(cmp)
unique(rfm[])
}

}
\seealso{
\code{\link{repDoy}}.
}
\author{
Florian Detsch
}
