% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp_lpdaac_accessoires.R
\name{lpdaac_getmod_names}
\alias{lpdaac_getmod_names}
\title{lpdaac_getmod_names}
\usage{
lpdaac_getmod_names(http, ftp, used_server, user, password, date_dir, v, h,
  tiled, out_folder_mod, gui)
}
\arguments{
\item{http}{string http site on lpdaac corresponding to a given MODIS product}

\item{ftp}{string ftp site corresponding to a given MODIS product}

\item{used_server}{string can assume values "http" or "ftp" depending on the
used download server; it cannot be NA}

\item{user}{username for earthdata server}

\item{password}{password for earthdata server}

\item{date_dir}{array of folder names containing data for the modis product
acquired in a given period (return array from lpdaac_getmod_dates)}

\item{v}{int. array containing a sequence of the vertical tiles of interest (e.g., c(18,19))}

\item{h}{int. array containing a sequence of the horizontal  tiles of interest (e.g., c(3,4))}

\item{tiled}{0/1 1 = tiled product; 0 = nontiled product (resolution 0.05 deg)}

\item{out_folder_mod}{ouput folder for original HDF storage}

\item{gui}{logical indicates if processing was called within the GUI environment
or not. If not, direct processing messages to the log}
}
\value{
Modislist names of HDF images corresponding to the requested tiles available
for the product in the selected date
}
\description{
Accessory function to find the names of HDF images corresponding
to a given date and interval of spatial tiles within the lpdaac archive
}
\note{
License: GPL 3.0
}
\author{
Original code by Babak Naimi (\code{.getModisList}, in
\href{http://r-gis.net/?q=ModisDownload}{ModisDownload.R})
modified to adapt it to MODIStsp scheme and to http archive (instead than old FTP) by:

Lorenzo Busetto, phD (2014-2016) \email{busetto.l@irea.cnr.it}

Luigi Ranghetti, phD (2016) \email{ranghetti.l@irea.cnr.it}
}
