% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODIStsp.R
\name{MODIStsp}
\alias{MODIStsp}
\title{MODIStsp main function}
\usage{
MODIStsp(
  ...,
  gui = TRUE,
  out_folder = NULL,
  out_folder_mod = NULL,
  opts_file = NULL,
  selprod = NULL,
  prod_version = NULL,
  bandsel = NULL,
  quality_bandsel = NULL,
  indexes_bandsel = NULL,
  sensor = NULL,
  download_server = NULL,
  downloader = NULL,
  user = NULL,
  password = NULL,
  download_range = NULL,
  start_date = NULL,
  end_date = NULL,
  spatmeth = NULL,
  start_x = NULL,
  end_x = NULL,
  start_y = NULL,
  end_y = NULL,
  bbox = NULL,
  spafile = NULL,
  out_projsel = NULL,
  output_proj = NULL,
  out_res_sel = NULL,
  out_res = NULL,
  resampling = NULL,
  reprocess = NULL,
  delete_hdf = NULL,
  nodata_change = NULL,
  scale_val = NULL,
  ts_format = NULL,
  out_format = NULL,
  compress = NULL,
  test = NULL,
  n_retries = 5,
  verbose = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{...}{not used for values, forces later arguments to bind by name}

\item{gui}{\code{logical} if TRUE: the GUI is opened before processing. If FALSE:
processing parameters are retrieved from the provided \code{opts_file}
argument), Default: TRUE}

\item{out_folder}{\code{character} Main output folder, default: NULL.}

\item{out_folder_mod}{\code{character} Output folder for original HDF storage.
If \code{"$tempdir"} (default), a temporary directory is used.}

\item{opts_file}{\code{character} full path to a JSON file
containing MODIStsp processing options saved from the GUI, Default: NULL}

\item{selprod}{\code{character} Name of selected MODIS product (e.g.,
Vegetation Indexes_16Days_250m (M*D13Q1)). You can get
a list of available product names using function \code{MODIStsp_get_prodnames},
Default: NULL}

\item{prod_version}{Version of the selected MODIS product.
Currently versions \code{"006"} and/or \code{"061"} can be chosen.
Default value is \code{"006"} until decommission of this version will be
announced by USGS.
Products with version \verb{"061} are experimental: in case users would encounter
an error in the encoding of bands or quality flags they are encouraged
to report it by opening a new issue on GitHub at
\url{https://github.com/ropensci/MODIStsp/issues}.}

\item{bandsel}{\verb{character array} Original MODIS layers to be processed.
You can get a list of available layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$bandnames),
Default: NULL}

\item{quality_bandsel}{\verb{character array} Quality Indicators to be computed starting from
bit fields of original MODIS layers. You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$quality_bandnames),
Default: NULL}

\item{indexes_bandsel}{\verb{character array}Spectral Indexes to be computed starting from reflectance bands.
You can get a list of available quality layers for a given product
using function \code{MODIStsp_get_prodlayers} (e.g., MODIStsp_get_prodlayers("M*D13Q1")$indexes_bandnames),
Default: NULL}

\item{sensor}{\code{character ["Terra"| "Aqua" | "Both"]} MODIS platform to be considered.
(Ignored for MCD* products). Default: "Both"}

\item{download_server}{\code{character ["http" | "offline"]} service to be used for
download. Default: "http"}

\item{downloader}{download_server \code{character ["http" | "aria2"]} downloader to be used,
Default: "http"}

\item{user}{\code{character} Username for NASA http server.
(\href{https://urs.earthdata.nasa.gov/home}{urs.earthdata.nasa.gov/home}).}

\item{password}{\code{character} Password for NASA http server
(\href{https://urs.earthdata.nasa.gov/home}{urs.earthdata.nasa.gov/home}).}

\item{download_range}{\code{character ["Full" | "Seasonal"]} If "full", all the
available images between the starting and the ending dates are downloaded;
If "seasonal", only the images included in the season are downloaded
(e.g: if the starting date is 2005-12-01 and the ending is 2010-02-31, only
the images of December, January and February from 2005 to 2010 - excluding
2005-01, 2005-02 and 2010-12 - are downloaded), Default: Full}

\item{start_date}{\code{character} Start date for images download and preprocessing
(yyyy.mm.dd), Default: NULL}

\item{end_date}{\code{character} End date for images download and preprocessing
(yyyy.mm.dd), Default: NULL}

\item{spatmeth}{\code{character ["tiles" | "bbox" | "file"]}, indicates how the processing
extent is retrieves. if "tiles", use the specified tiles (start_x....).
If "file", retrieve extent from spatial file specifies in \code{spafile}. If
"bbox", use the specified bounding box, Default: "tiles"}

\item{start_x}{\code{integer [0-35]} Start MODIS horizontal tile defining spatial extent.
Ignored if spatmeth != "tiles", Default: 18}

\item{end_x}{\code{integer [0-35]} End MODIS horizontal tile defining spatial extent.
Ignored if spatmeth != "tiles", Default: 18}

\item{start_y}{\code{integer [0-17]} Start MODIS vertical tile defining spatial extent.
Ignored if spatmeth != "tiles", Default: 4}

\item{end_y}{\code{integer [0-17]} End MODIS vertical tile defining spatial extent.
Ignored if spatmeth != "tiles", Default: 4}

\item{bbox}{\code{numeric(4)} Output bounding box (xmin, ymin, xmax, ymax) in
out_proj coordinate system. Ignored if spatmeth == "tiles", Default: NULL}

\item{spafile}{\code{character} (optional) full path of a spatial file
to use to derive the processing extent. If not NULL, the processing options
which define the extent, the selected tiles and the "Full Tile / Custom"
in the JSON options file are overwritten and new files are created on the
extent of the provided spatial file. Ignored if spatmeth != "file", Default: NULL}

\item{out_projsel}{\verb{character ["Native", "User Defined}] If "Native", the
outputs keep the original resolution of MODIS HDF images. Otherwise, the value
set in "out_res" is used, Default:Native}

\item{output_proj}{\code{character} either equal to "MODIS Sinusoidal",
or to the code of a valid EPSG or to a WKT projection string.
Ignored if outproj_sel == "Native", Default: NULL}

\item{out_res_sel}{\verb{character ["Native", "User Defined}]. If "Native", the
outputs keep the original resolution of MODIS HDF images. Otherwise, the value
set in "out_res" is used.}

\item{out_res}{\code{float} Output resolution (in output projection measurement
unit). Ignored if out_res_sel == "Native".}

\item{resampling}{\verb{character ["near" | "bilinear" | "cubic" | "cubicspline", |lanczos"|, "average"|, "mode", |"max"|, |"min"|, |"q1"|, |"q3"|, |"sum"|]}
Resampling method to be used by \code{gdalwarp}.}

\item{reprocess}{\code{logical} If TRUE, reprocess data for already existing dates.}

\item{delete_hdf}{\code{logical} If TRUE, delete downloaded HDF files after completion.}

\item{nodata_change}{\code{logical} if TRUE, NoData values are set to the max value
of the datatype of the layer on the MODIStsp output rasters. NOTE: If multiple
nodata values are reported for a layer, all are reset to the new value.}

\item{scale_val}{\code{logical} If TRUE,  scale and offset are applied to
original MODIS layers, and Spectral Indexes are saved as floating point. If
FALSE, no rescaling is done and Spectral Indexes are saved as integer, with a
10000 scaling factor.}

\item{ts_format}{\verb{character array including ["R RasterStack" | "ENVI Meta Files" | "GDAL VRT" | "ENVI and GDAL"]} Selected virtual time series format.}

\item{out_format}{\code{character ["ENVI" | "GTiff"]} Desired output format.}

\item{compress}{\code{character ["None" | "PACKBITS" | "LZW" | "DEFLATE"]}
Compression method for GTiff outputs (Ignored if \code{out_format == ENVI})}

\item{test}{\code{integer | character  (e.g., "01a")} if set, MODIStsp is executed in
"test mode", using a preset Options File instead than opening the GUI or accepting the
\code{opts_file} parameter. This allows both to check correct installation on
user's machines, and to implement unit testing.}

\item{n_retries}{\code{numeric} maximum number of retries on download functions.
In case any download function fails more than \code{n_retries} times consecutively,
MODIStsp_process will abort, Default: 20}

\item{verbose}{\code{logical} If FALSE, suppress processing messages,
Default: TRUE}

\item{parallel}{\code{logical} If TRUE (default), the function is run using parallel
processing, to speed-up the computation for large rasters (with a maximum
of 8 cores).
The number of cores is automatically determined; specifying it is also
possible (e.g. \code{parallel = 4}). In this case, more than 8 cores can be
specified. If FALSE (default), single core processing is used.}
}
\description{
Main function for the MODIS Time Series Processing Tool
(MODIStsp)
}
\details{
The function is used to:
\itemize{
\item initialize the processing (folder names, packages, etc.);
\item launch the GUI (\code{\link[=MODIStsp_GUI]{MODIStsp_GUI()}}) on interactive
execution, or load an options file to set processing arguments and/or
retrieve CLI inputs and run processing on non-interactive execution;
\item launch the routines for downloading and processing the requested datasets.
(\code{\link[=MODIStsp_process]{MODIStsp_process()}})
\item launching the function with GUI = FALSE and without specifying a opts_file
initializes arguments with default values. This allows making a test run.
}
}
\note{
License: GPL 3.0
}
\examples{
\donttest{

#' # - Running the tool using the GUI
# Running the tool without any option will start the GUI with the default or
# last used settings, in interactive mode (i.e., with gui = TRUE).
if (interactive()) {
  MODIStsp()
}


#' # - Running the tool specifying processing arguments in the call

# **NOTE** Output files of examples are saved to file.path(tempdir(), "MODIStsp").

# Here we process layers __NDVI__ and __EVI__ and quality indicator __usefulness__
# of product __M*D13Q1__, considering both Terra and Aqua platforms, for dates
# comprised between 2020-06-01 and 2020-06-15 and saves output to R tempdir
# --> See name and available layers for product M*D13Q1.
# Note that this example (as well as the following ones) is run in single
# core to follow CRAN policies, by setting parallel = FALSE.
# Users can exploit multicore functionalities skipping to set this argument.

MODIStsp_get_prodlayers("M*D13A2")
MODIStsp(
  gui = FALSE,
  out_folder = "$tempdir",
  selprod = "Vegetation_Indexes_16Days_1Km (M*D13A2)",
  bandsel = c("EVI", "NDVI"),
  quality_bandsel = "QA_usef",
  indexes_bandsel = "SR",
  user = "mstp_test" ,
  password = "MSTP_test_01",
  start_date = "2020.06.01",
  end_date = "2020.06.15",
  verbose = FALSE,
  parallel = FALSE
)


#' # - Running the tool using the settings previously saved in a specific options file

# **NOTE** Output files of examples are saved to file.path(tempdir(), "MODIStsp").
# You can run the examples with `gui = TRUE` to set a different output folder!

# Here we use a test json file saved in MODIStsp installation folder which
# downloads and processed 3 MOD13A2 images over the Como Lake (Lombardy, Italy)
# and retrieves NDVI and EVI data, plus the Usefulness Index Quality Indicator.

opts_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")

MODIStsp(gui = FALSE, opts_file = opts_file, verbose = TRUE, parallel = FALSE)


# Running the tool using the settings previously saved in a specific option file
# and specifying the extent from a spatial file allows to re-use the same
# processing settings to perform download and reprocessing on a different area

opts_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")
spatial_file <- system.file("testdata/lakeshapes/garda_lake.shp", package = "MODIStsp")
MODIStsp(
  gui = FALSE, 
  opts_file = opts_file,
  spatmeth = "file",
  spafile = spatial_file, 
  verbose = TRUE,
  parallel = FALSE
)


# Running the tool using the settings previously saved in a
# specific options file and specifying each time the extent from a different
# spatial file (e.g., to perform the same processing on several extents)
# Note that you can also put all your extent files in a specific folder and
# create the extent list using for example.

extent_list = list.files(
  system.file("testdata/lakeshapes/", package = "MODIStsp"),
  "\\\\.shp$", 
  full.names = TRUE
)
extent_list
opts_file <- system.file("testdata/test_MOD13A2.json", package = "MODIStsp")

for (single_shape in extent_list) {
  MODIStsp(
    gui = FALSE, 
    opts_file = opts_file,
    spatmeth = "file",
    spafile = single_shape, 
    verbose = TRUE,
    parallel = FALSE
  )
}

# output files are placed in separate folders:
outfiles_garda <- list.files(
  file.path(tempdir(), "MODIStsp/garda_lake/VI_16Days_1Km_v6/NDVI"),
  full.names = TRUE
)
outfiles_garda
require(raster)
if (length(outfiles_garda) > 0) {
  plot(raster(outfiles_garda[1] ))
}

outfiles_iseo <- list.files(
  file.path(tempdir(), "MODIStsp/iseo_lake/VI_16Days_1Km_v6/NDVI"),
  full.names = TRUE
)
outfiles_iseo
if (length(outfiles_garda) > 0) {
  plot(raster(outfiles_iseo[1]))
}

# See also https://docs.ropensci.org/MODIStsp/articles/noninteractive_execution.html
}
}
\seealso{
\code{\link[=MODIStsp_GUI]{MODIStsp_GUI()}}, \code{\link[=MODIStsp_process]{MODIStsp_process()}}
}
\author{
Lorenzo Busetto, phD (2014-2017)

Luigi Ranghetti, phD (2015-2017) \email{luigi@ranghetti.info}
}
