% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_vectorized_smoof.R
\name{make_vectorized_smoof}
\alias{make_vectorized_smoof}
\title{Make vectorized smoof function}
\usage{
make_vectorized_smoof(prob.name, ...)
}
\arguments{
\item{prob.name}{name of the problem to build}

\item{...}{other parameters passed to each specific function}
}
\description{
Make a vectorized version of test functions available in package "smoof".
}
\details{
This routine builds MOEADr-compliant versions of the classic multiobjective
test functions available in package smoof. The most commonly used ones are:

\itemize{
\item \code{prob.name = ZDT1, ... , ZDT6}, in which case the function
requires additional parameter \code{dimensions} (positive integer)
\item \code{prob.name = DTLZ1, ..., DTLZ7}, in which case the function
requires additional parameters \code{dimensions} (positive integer),
\code{n.objectives} (= 2 or 3) and, for DTLZ4, \code{alpha}
(positive integer, defaults to 100).
\item \code{prob.name = UF}, in which case the function requires
additional parameters \code{dimensions} (positive integer) and
\code{id} (= 1, ..., 10).
}
}
\examples{
\dontrun{
  library(smoof)
  DTLZ2 <- make_vectorized_smoof(prob.name    = "DTLZ2",
                                 dimensions   = 10,
                                 n.objectives = 2)
  DTLZ2(X = matrix(runif(100), ncol = 10))
}

}
