% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{getmax}
\alias{getmax}
\title{getmax generates the upper bound for a plot}
\usage{
getmax(x, mult = 1.05)
}
\arguments{
\item{x}{the vector of data to be tested for its maximum}

\item{mult}{the multiplier for both ends, defaults to 1.05 (=0.95 if < 0)}
}
\value{
a suitable upper bound for a plot if required
}
\description{
getmax generates an upper bound for a plot where it 
    is unknown whether the maximum is greater than zero of not. 
    If > 0 then multiplying by the default mult of 1.05 works well 
    but if the outcome if < 0 then the multiplier needs to be 
    adjusted appropriately so the maximum is slightly higher than 
    the maximum of the data
}
\examples{
 vect <- rnorm(10,mean=0,sd=2)
 sort(vect,decreasing=TRUE)
 getmax(vect,mult=1.0)
 vect <- rnorm(10,mean = -5,sd = 1.5)
 sort(vect,decreasing=TRUE)
 getmax(vect,mult=1.0)
}
