% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{plot.dynpop}
\alias{plot.dynpop}
\title{plot.dynpop an S3 method for plotting dynpop objects}
\usage{
\method{plot}{dynpop}(x, y = NULL, main = "", cex = 0.9, font = 7, ...)
}
\arguments{
\item{x}{a dynpop matrix containing at least year, nt, and nt1 as
columns, as returned invisibly from discretelogistic.}

\item{y}{a second y value added to the first plot if present}

\item{main}{defines text to print across top of plot with the
intention of including the parameter values, default=""}

\item{cex}{the size of the fonts used, default=0.9}

\item{font}{the font used default=7 (bold serif) 1 = non-serif,
2 = bold non-serif, 6 = serif}

\item{...}{ready for extra graphical parameters}
}
\value{
it returns the dynpop matrix invisibly
}
\description{
plot.dynpop an S3 method for plotting dynpop objects
    which are generated by the function discretelogistic. It 
    generaes a plot of the numbers through time, that is year x Nt,
    and a second plotthat is a phase plot of Nt+1 vs Nt, to better
    illustrate the dynamics and simplify the search for equilibria.
    The input is designed to be the invisibly produced output from
    the MQMF function discretelogistic, but as long as there is at
    least a matrix of year, Nt, and Nt+1 with a class of dynpop, 
    then a call to plot should generate the two graphs.
}
\examples{
\dontrun{
  r <- 2.5; K <- 1000.0; N0 <- 50; Ct <- 0.0; yrs <- 50; p <- 1
  pop <- discretelogistic(r=r,K=K,N0=N0,Ct=Ct,Yrs=yrs,p=p)
  plot(pop,main=paste0("r=",r,"  K=",K,"  Ct=",Ct, "  N0=",N0,
                       "  p=",p),cex=0.85,font=7)
}
}
