% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_clara_jaccard.R
\name{fast_clara_jaccard}
\alias{fast_clara_jaccard}
\title{Fast CLARA-like clustering using Jaccard dissimilarity}
\usage{
fast_clara_jaccard(
  data,
  k,
  samples = 20,
  samplesize = NULL,
  seed = 123,
  frac = 1
)
}
\arguments{
\item{data}{A state matrix of censored time-to-event indicators as computed by the \code{make_state_matrix} function.}

\item{k}{Number of returned clusters.}

\item{samples}{Number of random samples drawn from the analysed population.}

\item{samplesize}{Number of patients per sample (default: min(50 + 5k, ncol(data))).}

\item{seed}{Random seed for reproducibility (default: 123).}

\item{frac}{Fraction of the population to use for cost computation (default: 1).}
}
\value{
A list with index of patients from the sample a, medoid indices, cluster assignment, and cost.
\describe{
\item{clustering}{An integer vector of cluster assignments for each patient.}
\item{medoids}{Indices of medoids associated witht the lower cost.}
\item{sample}{Indices of the sampled columns used in clustering.}
\item{cost}{Total cost (sum of dissimilarities to assigned medoids).}
}
}
\description{
Implements a CLARA (Clustering Large Applications) strategy using Jaccard dissimilarity
computed on individual patients state matrices. The algorithm repeatedly samples subsets of the data,
performs PAM clustering on each subset, and selects the medoids that minimise the total dissimilarity across
the full dataset. Final assignments are made by mapping all data points to the nearest selected medoid.
}
\details{
This implementation adapts the original CLARA method described by Kaufman and Rousseeuw (1990)
in "Finding Groups in Data: An Introduction to Cluster Analysis".
}
\note{
To improve efficiency, the function used fastpam procedure from the fastkmedoids library and uses optimized Jaccard index computation.
For simulation purpose, the \code{frac} parameter can be used to reduce time when computing the cost for each sample. The final cost is given using medoids associated with lower cost computed on fractionned data. A final analysis using the proper CLARA method should be conducted setting \code{frac} to 1.
}
\references{
Kaufman, L. & Rousseeuw, P. J. (1990). \emph{Finding Groups in Data: An Introduction to Cluster Analysis}. Wiley.
}
