% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.r
\name{ggplot.mscmt}
\alias{ggplot.mscmt}
\title{Plotting Results of mscmt with ggplot2}
\usage{
\method{ggplot}{mscmt}(x, what, type = c("gaps", "comparison", "placebo.gaps",
  "placebo.data", "p.value"), treatment.time, zero.line = TRUE, ylab,
  xlab = "Date", main, col, lty, lwd, legend = TRUE, bw = FALSE,
  date.format, unit.name, full.legend = TRUE, include.smooth = FALSE,
  include.mean = FALSE, include.synth = FALSE, draw.estwindow = TRUE,
  what.set, limits = NULL, alpha = 1, alpha.min = 0.1,
  exclude.units = NULL, exclude.ratio = Inf, ratio.type = c("rmspe",
  "mspe"), alternative = c("two.sided", "less", "greater"),
  draw.points = TRUE, control.name = "control units", size = 1)
}
\arguments{
\item{x}{An object of class \code{"mscmt"}, usually obtained as
the result of a call to function \code{\link{mscmt}}.}

\item{what}{A character vector. Name(s) of the variables to be plotted. If 
missing, the (first) dependent variable will be used.}

\item{type}{A character scalar denoting the type of the plot containing 
either \code{"gaps"}, \code{"comparison"}, \code{"placebo.gaps"}, 
\code{"placebo.data"}, or \code{"p.value"}. 
Partial matching allowed, defaults to \code{"placebo.gaps"}, if results
of a placebo study are present, and to \code{"gaps"}, else.}

\item{treatment.time}{An optional scalar (numeric, character, or 
\code{\link[base]{Date}}) giving the treatment time. 
If \code{treatment.time} is numeric, Jan 01 of that year will be used. If 
\code{treatment.time} is a character string, it will be converted to a 
\code{\link[base]{Date}} and must thus be in an unambiguous format.
A vertical dotted line at the given point in time is included in the plot.}

\item{zero.line}{A logical scalar. If \code{TRUE} (default), a horizontal
dotted line (at zero level) is plotted for \code{"gaps"} and 
\code{"placebo.gaps"} plots.}

\item{ylab}{Optional label for the y-axis, automatically generated if 
missing.}

\item{xlab}{Optional label for the x-axis, defaults to \code{"Date"}.}

\item{main}{Optional main title for the plot, automatically generated 
if missing.}

\item{col}{Optional character vector with length 1 (for gaps plots) or
2 (for all other plot types). For comparison plots, \code{col} contains the
colours for the actual and synthesized data, for placebo.plots (with 
\code{full.legend==FALSE}), \code{col} contains the colours for 
the treated unit and the control units. Automatically generated 
if missing.}

\item{lty}{Optional numerical vector with length 1 (for gaps plots) or
2 (for all other plot types). For comparison plots, \code{lty} contains the
linetypes for the actual and synthesized data, for placebo.plots (with 
\code{full.legend==FALSE}), \code{col} contains the linetypes for 
the treated unit and the control units. Automatically generated 
if missing.}

\item{lwd}{Optional numerical vector with length 1 (for gaps plots) or
2 (for all other plot types). For comparison plots, \code{lty} contains the
linewidths for the actual and synthesized data, for placebo.plots (with 
\code{full.legend==FALSE}), \code{col} contains the linewidths for 
the treated unit and the control units. Automatically generated 
if missing.}

\item{legend}{A logical scalar. If \code{TRUE} (default), a legend is 
included in the plot.}

\item{bw}{A logical scalar. If \code{FALSE} (default), the automatically 
generated colours and line types are optimized for a colour plot, 
if \code{TRUE}, the automatic colours and line types are set for a black and
white plot.}

\item{date.format}{A character string giving the format for the tick labels
of the x axis as documented in \code{\link[base]{strptime}}. Defaults to
\code{"\%b \%y"} or \code{"\%Y"}, depending on the granularity of the data.}

\item{unit.name}{A character string with the title of the legend 
for comparison and placebo plots. Defaults to "Estimation" for comparison 
and "Unit" for placebo plots.}

\item{full.legend}{A logical scalar. If \code{TRUE} (default), a full legend
of all units (donors) is constructed. If \code{FALSE}, only the treated and
the control units are distinguished.}

\item{include.smooth}{A logical scalar. If \code{TRUE}, a geometric smoother
based on the control units is added to placebo plots. Default: \code{FALSE}.}

\item{include.mean}{A logical scalar. If \code{TRUE}, the arithmetic mean
of all control units is added to placebo plots. Default: \code{FALSE}.}

\item{include.synth}{A logical scalar. If \code{TRUE}, the synthesized data
for the treated unit are added to plots of type \code{"placebo.data"}.
Defaults to \code{FALSE}.}

\item{draw.estwindow}{A logical scalar. If \code{TRUE} (default), the time
range containing all optimization periods is shaded in the corresponding
plots.}

\item{what.set}{An optional character string for a convenient selection of 
multiple variables. Accepted values are \code{"dependents"}, 
\code{"predictors"}, and \code{"all"}, which collects all dependent, all
predictor, or all variables of both types, respectively. Overrides parameter
\code{what} (if the latter is present).}

\item{limits}{An optional vector of length 2 giving the range of the plot or
\code{NULL}.
If \code{limits} is numeric, Jan 01 of the corresponding years will be used.
If \code{limits} is of type character, both strings will be converted to 
Dates (via \code{\link[base]{as.Date}}) and must thus be in an unambiguous 
format.}

\item{alpha}{Either a numerical scalar, a numerical vector of length 
corresponding to the number of units, or the character string \code{"auto"}.
If \code{alpha} is a numerical scalar (default with value \code{1}), a fixed
value for the alpha channel (transparency) is included for all units in 
placebo plots. If \code{alpha} is numeric and has length corresponding to the
number of units, these values are assigned as alpha channel to the individual 
units. If \code{"auto"}, the alpha channel information is obtained from the
w weights of the control units.}

\item{alpha.min}{A numerical scalar (default: \code{0.1}). If \code{alpha} is
set to \code{"auto"}, the individual alpha channel information for control 
unit \code{i} is set to \code{alpha.min + (1-alpha.min) * w[i]}.}

\item{exclude.units}{An optional (default: \code{NULL}) character vector with 
names for control units which shall be excluded from placebo plots and
p-value calculations.}

\item{exclude.ratio}{A numeric scalar (default: \code{Inf}). Control units 
with a pre-treatment (r)mspe of more than \code{exclude.ratio} times
the pre-treatment (r)mspe of the treated unit are excluded from placebo 
plots and p-value calculations.}

\item{ratio.type}{A character string. Either \code{rmspe} (default) or 
\code{mspe}. Selects whether root mean squared errors or mean squared errors 
are considered for the exclusion of control units (see \code{exclude.ratio}).}

\item{alternative}{A character string giving the alternative of the test for 
plots of type \code{"p.value"}. Either \code{"two.sided"} (default), 
\code{"less"}, or \code{"greater"}.}

\item{draw.points}{A logical scalar. If \code{TRUE} (default), points are
added to the line plots to enhance visibility.}

\item{control.name}{A character string for the naming of the non-treated
units in placebo plots. Defaults to \code{"control units"}.}

\item{size}{A numerical scalar (default: \code{1}). If \code{draw.points} is
\code{TRUE} (default), \code{size} specifies the size of the points.}
}
\value{
An object of class \code{\link[ggplot2]{ggplot}}.
}
\description{
\code{ggplot.mscmt} plots results of \code{\link{mscmt}} based on 
\code{\link[ggplot2]{ggplot}}.
}
\details{
A unified plot method for gaps plots, comparison of treated and synthetic
values, as well as plots for placebo studies, based on 
\code{\link[ggplot2]{ggplot}}. \code{\link{ggplot.mscmt}} is the preferred
plot method and has more functionality than \code{\link{plot.mscmt}}.
}
