% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetHypTest.R
\name{HolmBonferroni}
\alias{HolmBonferroni}
\title{Apply Holm-Bonferroni method to adjust for multiple tests}
\usage{
HolmBonferroni(pTable, model, alpha = 0.05)
}
\arguments{
\item{pTable}{a table of quartets with p-values, as computed by
\code{quartetTreeTestInd} or \code{quartetStarTestInd}}

\item{model}{one of \code{"T1"}, \code{"T3"}, or \code{"star"}, where \code{pTable} contains a column \code{p_model} of p-values}

\item{alpha}{a critical value, for rejection of adjusted p-values less than or equal to \code{alpha}}
}
\value{
the same table, with rows reordered, and 2 new columns of 1) adjusted p-values,
and 2) "Y" or "N" for indicating "reject" or "fail to reject"
}
\description{
Apply the Holm-Bonferroni method to
adjust for multiple hypothesis tests performed on quartets from a data set of gene trees.
}
\details{
When p-values are computed for each quartet using
\code{quartetTreeTestInd} or \code{quartetStarTestInd},
multiple comparisons are being done for one dataset. The
Holm-Bonferroni method \insertCite{HolmBonf79}{MSCquartets} adjusts these p-values upward,
controlling the familywise error rate. The probability
of at least one false discovery (rejection of the null hypothesis)
is no more than the significance level.

The Holm-Bonferroni method does not require that test hypotheses are independent, which
is important for its application to quartet counts presumed to have arisen on a single
species tree.

This can be a low power test (often failing to reject when the null hypothesis is false).
In particular for the T1 and T3 tests, it does not consider the relationships between edge
lengths for different sets of four taxa.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
taxanames=taxonNames(gtrees)
QT=quartetTable(gtrees,taxanames[1:6])
RQT=quartetTableResolved(QT)
pTable=quartetTreeTestInd(RQT,"T3")
pTable[1:10,]
HBpTable=HolmBonferroni(pTable,"T3",.05)
HBpTable[1:10,]

}
\references{
\insertRef{HolmBonf79}{MSCquartets}
}
\seealso{
\code{\link{quartetTreeTestInd}}, \code{\link{quartetStarTestInd}}
}
