% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetHypTest.R
\name{quartetTreeTestInd}
\alias{quartetTreeTestInd}
\title{Multiple independent hypothesis tests for quartet counts fitting a species tree under the MSC}
\usage{
quartetTreeTestInd(
  rqt,
  model = "T3",
  lambda = 0,
  method = "MLest",
  smallcounts = "approximate",
  bootstraps = 10^4,
  speciestree = NULL
)
}
\arguments{
\item{rqt}{table of resolved quartet counts, as produced by \code{quartetTableResolved}, or \code{quartetStarTestInd}}

\item{model}{\code{"T1"} for a specific species tree topology, or \code{"T3"} for any species tree topology, with these
models explained more fully by \insertCite{MAR19;textual}{MSCquartets}}

\item{lambda}{power divergence statistic parameter (e.g., 0 for likelihood ratio statistic, 1 for Chi-squared statistic)}

\item{method}{\code{"MLest"}, \code{"conservative"}, or \code{"bootstrap"}; see \code{quartetTreeTest} for explanation}

\item{smallcounts}{\code{"bootstrap"} or \code{"approximate"}, method of obtaining p-value when some counts are small, so
the chosen \code{method} is inappropriate}

\item{bootstraps}{number of samples for bootstrapping}

\item{speciestree}{species tree, in Newick as text, to determine quartet for T1 test; required for \code{model="T1"},
ignored for \code{model="T3"}}
}
\value{
if \code{model="T3"}, a copy of \code{rqt} with a new column \code{"p_T3"} appended with p-values for each quartet;
  if \code{model="T1"}, a copy of \code{rqt} with 2 columns appended: \code{"p_T1"} with p-values, and \code{"qindex"}
  giving index of quartet consistent with specified species tree,
  i.e., 1 if 12|34 on species tree, 2 if 13|24, 3 if 14|23
}
\description{
Perform a tree hypothesis test for all quartet counts in an input table, as if the counts for different choices of 4 taxa
are independent.
}
\details{
This function assumes all quartets are resolved.  The test performed and the arguments
are described more fully in \code{QuartetTreeTest}.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=c("t1","t2","t3","t4","t5","t6")
QT=quartetTable(gtrees,tnames)
RQT=quartetTableResolved(QT)
stree="(((t5,t6),t4),((t1,t2),t3));"
pTable3=quartetTreeTestInd(RQT,"T3")
quartetTablePrint(pTable3[1:6,])
stree="((((t5,t6),t4),t7),((t8,t9),((t1,t2),t3)));"
pTable1=quartetTreeTestInd(RQT,"T1",speciestree=stree)
quartetTablePrint(pTable1[1:6,])

}
\references{
\insertRef{MAR19}{MSCquartets}
}
\seealso{
\code{\link{quartetTreeTest}}, \code{\link{quartetTestPlot}}, \code{\link{quartetStarTestInd}}, \code{\link{quartetTableResolved}}
}
