% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeOfBlobs.R
\name{treeOfBlobs}
\alias{treeOfBlobs}
\title{Tree of blobs for a network}
\usage{
treeOfBlobs(net, plot = FALSE)
}
\arguments{
\item{net}{A network, supplied as an extended Newick string, an evonet object, or an igraph object}

\item{plot}{if TRUE (default), plot the tree of blobs.}
}
\value{
An object of class \code{phylo} containing the unrooted topological tree
derived from the network by contracting all blobs.  All edge lengths are 1.
}
\description{
Given extended newick, an evonet object, or an igraph object for a network, return its reduced, unrooted
tree of blobs. Here 'reduced' means all nodes resulting from 2-blobs are suppressed, as are edges above
the network's LSA.
}
\examples{
network = "(((a:1,d:1):1,(b:1)#H1:1):1,(#H1,c:1):2);"
plot(read.evonet(text=network))
treeOfBlobs(network, plot=TRUE)

}
\seealso{
\code{\link{TINNIK}}
}
