% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{DIC}
\alias{DIC}
\alias{DIC.MSGARCH_MCMC_FIT}
\title{Deviance Information Criterion (DIC).}
\usage{
DIC(fit)

\method{DIC}{MSGARCH_MCMC_FIT}(fit)
}
\arguments{
\item{fit}{Fit object of type \code{MSGARCH_MCMC_FIT} created
with \code{\link{FitMCMC}}.}
}
\value{
A list with the following elements:
       \itemize{
       \item \code{DIC}: Deviance Information Criterion.
       \item \code{IC}: Bayesian Predictive Information Criterion (IC = 2 * pV + D.bar).
       \item \code{pV}: Effective number of parameters (pV = var(D)/2).
       \item \code{D.bar}: Expected value of the deviance over the posterior.
       }
}
\description{
Method which computes the Deviance Information Criterion (DIC) from a fit object of type
\code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.
}
\details{
Computes the Deviance information criterion of Spiegelhalter et al. (2002).
}
\examples{
# create model specification
spec <- CreateSpec()

# load data
data("SMI", package = "MSGARCH")

# fit the model on data by MCMC
set.seed(123)
fit <- FitMCMC(spec = spec, data = SMI, ctr = list(nburn = 500L, nmcmc = 500L))

# compute DIC
DIC(fit)
}
\references{
Spiegelhalter, David J., et al. (2002).
Bayesian measures of model complexity and fit.
\emph{Journal of the Royal Statistical Society: Series B}, 64, 583-639
}
