# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Covariance to correlation matrix
#' 
#' @description This function takes an (\code{n x n}) covariance matrix and returns the associated (\code{n x n}) correlation matrix.
#' 
#' @param \code{cov_mat} A (\code{n x n}) covariance matrix.
#' 
#' @return A (\code{n x n}) correlation matrix.
#' 
#' @keywords internal
#' 
#' @export
cov2corr <- function(cov_mat) {
    .Call(`_MSTest_cov2corr`, cov_mat)
}

#' @title Covariance vech function
#' 
#' @description This function returns the half-vectorization of an input matrix as a column vector.
#' 
#' @param \code{mat} A (\code{n x n}) covariance matrix.
#' 
#' @return A \code{(n+1)*n/2} column vector.
#' 
#' @keywords internal
#' 
#' @export
covar_vech <- function(mat) {
    .Call(`_MSTest_covar_vech`, mat)
}

#' @title Covariance vech to matrix 
#' 
#' @description This function undoes the half-vectorization of a covariance matrix.
#' 
#' @param \code{sig} A (n+1)*n/2 vector.
#' @param \code{n} Integer determining shape of the original matrix.
#' 
#' @return A (\code{n x n}) covariance matrix.
#' 
#' @keywords internal
#' 
#' @export
covar_unvech <- function(sig, n) {
    .Call(`_MSTest_covar_unvech`, sig, n)
}

#' @title Random Transition Matrix
#' 
#' @description This function creates a random transition matrix.
#' 
#' @param \code{k} Number of regimes. Must be greater than or equal to \code{2}. 
#' 
#' @return Transition matrix with randomly generated entries.
#' 
#' @keywords internal
#' 
#' @export
randP <- function(k) {
    .Call(`_MSTest_randP`, k)
}

#' @title Ergodic (limiting) probabilities of states
#' 
#' @description Takes a transition matrix and returns the limiting probabilities.
#' 
#' @param \code{P} Matrix with transition probabilities.
#' 
#' @return A (\code{k x 1}) vector of limiting probabilities.
#' 
#' @keywords internal
#' 
#' @export
limP <- function(P) {
    .Call(`_MSTest_limP`, P)
}

#' @title Lagged Time Series Data
#' 
#' @description This function takes a (\code{T x 1}) vector \code{Y} and returns the (\code{T-p x 1}) vector \code{y} and the (\code{T-p x p}) matrix of lagged observations.
#' 
#' @param \code{Y} Vector with time series observations.
#' @param \code{p} integer for the number of lags to use in estimation. Must be greater than or equal to \code{1}.
#' 
#' @return List with vector \code{y} (vector of lagged \code{Y}) and matrix \code{X} of lagged observations.
#' 
#' @keywords internal
#' 
#' @export
ts_lagged <- function(Y, p) {
    .Call(`_MSTest_ts_lagged`, Y, p)
}

#' @title Parameter list for Markov-switching autoregressive model
#' 
#' @description This function takes the parameter vector of interest and converts it to a list with specific parameter vectors needed for univariate Markov-switching functions.
#' 
#' @param \code{theta} Vector of parameters.
#' @param \code{p} Number of autoregressive lags.
#' @param \code{k} Number of regimes.
#' @param \code{msmu} Boolean indicating if the mean switches with regime.
#' @param \code{msvar}Boolean indicating if the variance switches with regime. 
#' 
#' @return List with the mean, variance, transition matrix, limiting probabilities, and a vector of state indicators.
#' 
#' @keywords internal
#' 
#' @export
paramList_MSARmdl <- function(theta, p, k, msmu, msvar) {
    .Call(`_MSTest_paramList_MSARmdl`, theta, p, k, msmu, msvar)
}

#' @title Parameter list for Markov-switching vector autoregressive model
#' 
#' @description This function takes the parameter vector of interest and converts it to a list with specific parameter vectors needed for multivariate Markov-switching functions.
#' 
#' @param \code{theta} Vector of parameters.
#' @param \code{q} Number of time series.
#' @param \code{p} Number of autoregressive lags.
#' @param \code{k} Number of regimes.
#' @param \code{msmu} Boolean indicating if the mean switches with regime.
#' @param \code{msvar} Boolean indicating if the variance switches with regime. 
#' 
#' @return List with the mean, variance, transition matrix, limiting probabilities, and a vector of state indicators.
#' 
#' @keywords internal
#' 
#' @export
paramList_MSVARmdl <- function(theta, q, p, k, msmu, msvar) {
    .Call(`_MSTest_paramList_MSVARmdl`, theta, q, p, k, msmu, msvar)
}

#' @title Markov-switching autoregressive model residuals
#' 
#' @description This function computes residuals of a Markov-switching autoregressive model.
#' 
#' @param \code{mdl} List containing relevant parameters.
#' @param \code{mu} Vector with mean in each regime.
#' @param \code{k} number of regimes. Must be greater than or equal to \code{2}. 
#' 
#' @return A (\code{TxM}) matrix of residuals in each regime \code{M} where \code{M=k^(ar+1)}.
#' 
#' @keywords internal
#' 
#' @export
calcResid_MSARmdl <- function(mdl, mu, k) {
    .Call(`_MSTest_calcResid_MSARmdl`, mdl, mu, k)
}

#' @title Markov-switching vector autoregressive model residuals
#' 
#' @description This function computes residuals of a Markov-switching vector autoregressive model. 
#' 
#' @param \code{mdl} List containing relevant parameters.
#' @param \code{mu} Vector with mean in each regime.
#' @param \code{k} Number of regimes. Must be greater than or equal to \code{2}. 
#' 
#' @return List with \code{M} (\code{Txq}) matrices of residuals in each regime \code{M} where \code{M=k^(ar+1)}.
#' 
#' @keywords internal
#' 
#' @export
calcResid_MSVARmdl <- function(mdl, mu, k) {
    .Call(`_MSTest_calcResid_MSVARmdl`, mdl, mu, k)
}

#' @title Initial values for Hidden Markov model
#' 
#' @description This function generates a random parameter vector to be used as initial values for a Hidden Markov model.
#' 
#' @param \code{mdl} List with parameter values of simple (one-regime) model. This includes:
#' \itemize{
#'   \item{\code{mu}: }{Vector of means.}
#'   \item{\code{sigma}: }{covariance matrix.}
#'   \item{\code{msmu}: }{Boolean indicator. If \code{TRUE}, mean is function of markov process. If \code{FALSE}, mean is constant across regimes.}
#'   \item{\code{msvar}: }{Boolean indicator. If \code{TRUE}, standard deviation is function of markov process. If \code{FALSE}, standard deviation is constant across regimes.}
#' }
#' @param \code{k} Number of regimes.
#' 
#' @return Vector of initial parameter values.
#' 
#' @keywords internal
#' 
#' @export
initVals_HMmdl <- function(mdl, k) {
    .Call(`_MSTest_initVals_HMmdl`, mdl, k)
}

#' @title Initial values for Markov-switching autoregressive model
#' 
#' @description This function generates a random parameter vector to be used as initial values for a Markov-switching autoregressive model.
#' 
#' @param \code{mdl} List with parameter values of simple (one-regime) autoregressive model. This includes:
#' \itemize{
#'   \item{\code{phi}: }{Vector autoregressive coefficients.}
#'   \item{\code{mu}: }{Mean of process.}
#'   \item{\code{stdev}: }{Standard deviation.}
#'   \item{\code{msmu}: }{Boolean indicator. If \code{TRUE}, mean is function of markov process. If \code{FALSE}, mean is constant across regimes.}
#'   \item{\code{msvar}: }{Boolean indicator. If \code{TRUE}, standard deviation is function of markov process. If \code{FALSE}, standard deviation is constant across regimes.}
#' }
#' @param \code{k} Number of regimes.
#' 
#' @return Vector of initial parameter values.
#' 
#' @keywords internal
#' 
#' @export
initVals_MSARmdl <- function(mdl, k) {
    .Call(`_MSTest_initVals_MSARmdl`, mdl, k)
}

#' @title Initial values for Markov-switching vector autoregressive model
#' 
#' @description This function generates a random parameter vector to be used as initial values for a Markov-switching vector autoregressive model.
#' 
#' @param \code{mdl} List with parameter values of simple (one-regime) vector autoregressive model. This includes:
#'   \itemize{
#'    \item{\code{phi}: }{Matrix autoregressive coefficients.}
#'    \item{\code{mu}: }{Vector of means.}
#'    \item{\code{sigma}: }{Covariance matrix.}
#'    \item{\code{msmu}: }{Boolean indicator. If \code{TRUE}, mean is function of markov process. If \code{FALSE}, mean is constant across regimes.}
#'    \item{\code{msvar}: }{Boolean indicator. If \code{TRUE}, standard deviation is function of markov process. If \code{FALSE}, standard deviation is constant across regimes.}
#' }
#' @param \code{k} Number of regimes.
#' 
#' @return Vector of initial parameter values.
#' 
#' @keywords internal
#' 
#' @export
initVals_MSVARmdl <- function(mdl, k) {
    .Call(`_MSTest_initVals_MSVARmdl`, mdl, k)
}

#' @title Monte Carlo P-value
#' 
#' @description This function computes the Monte Carlo P-value.
#' 
#' @param test_stat Test statistic under the alternative (e.g. \code{S_0}).
#' @param null_vec A (\code{N x 1}) vector with test statistic under the null hypothesis.
#' @param type String determining type of test. options are: "geq" for right-tail test, "leq" for left-tail test, "abs" for absolute value test and "two-tail" for two-tail test.
#' 
#' @return MC p-value of test
#' 
#' @references Dufour, Jean-Marie 2006. "Monte Carlo tests with nuisance parameters: A general approach to finite-sample inference and nonstandard asymptotics". \emph{Journal of Econometrics}, 133(2), 443-477.
#' @references Dufour, Jean-Marie, and Richard Luger. 2017. "Identification-robust moment-based tests for Markov switching in autoregressive models". \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export
MCpval <- function(test_stat, null_vec, type = "geq") {
    .Call(`_MSTest_MCpval`, test_stat, null_vec, type)
}

#' @title Standard normal errors using box Muller 
#' 
#' @description This function generates uncorrelated standard normal processes using box Muller method.
#' 
#' @param \code{n} Integer determining the length of the process to be simulated
#' @param \code{q}  Integer determining the number of processes to be simulated
#' 
#' @return A (\code{T x q}) matrix of standard normal distributed errors
#' 
#' @keywords internal
#' 
#' @export
randSN <- function(n, q) {
    .Call(`_MSTest_randSN`, n, q)
}

#' @title Simulate autoregressive process
#' 
#' @description This function simulates an autoregresive process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{mu}: }{Mean of process.}
#'   \item{\code{sigma}: }{Standard deviation of process.}
#'   \item{\code{phi}: }{Vector of autoregressive coefficients.}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated autoregressive series and its DGP parameters.
#' 
#' @example /inst/examples/simuAR_examples.R
#' @export
simuAR <- function(mdl_h0, burnin = 100L) {
    .Call(`_MSTest_simuAR`, mdl_h0, burnin)
}

#' @title Simulate Markov-switching autoregressive process
#' 
#' @description This function simulates a Markov-switching autoregressive process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{k}: }{Number of regimes.}
#'   \item{\code{mu}: }{A (\code{k x 1}) vector with mean of process in each regime.}
#'   \item{\code{sigma}: }{A (\code{k x 1}) vector with standard deviation of process in each regime.}
#'   \item{\code{phi}: }{Vector of autoregressive coefficients.}
#'   \item{\code{P}: }{A (\code{k x k}) transition matrix (columns must sum to one).}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated Markov-switching autoregressive process and its DGP properties.
#' 
#' @example /inst/examples/simuMSAR_examples.R
#' @export
simuMSAR <- function(mdl_h0, burnin = 100L) {
    .Call(`_MSTest_simuMSAR`, mdl_h0, burnin)
}

#' @title Simulate VAR process
#' 
#' @description This function simulates a vector autoregresive process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{mu}: }{A (\code{q x 1}) vector of means.}
#'   \item{\code{sigma}: }{A (\code{q x q}) covariance matrix.}
#'   \item{\code{phi}: }{ A (\code{q x qp}) matrix of autoregressive coefficients.}
#'   \item{\code{p}: }{Number of autoregressive lags.}
#'   \item{\code{q}: }{Number of series.}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated vector autoregressive series and its DGP parameters.
#' 
#' @example /inst/examples/simuVAR_examples.R
#' @export
simuVAR <- function(mdl_h0, burnin = 100L) {
    .Call(`_MSTest_simuVAR`, mdl_h0, burnin)
}

#' @title Simulate Markov-switching vector autoregressive process
#' 
#' @description This function simulates a Markov-switching vector autoregressive process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{k}: }{Number of regimes.}
#'   \item{\code{mu}: }{A (\code{k x q}) matrix of means.}
#'   \item{\code{sigma}: }{List with \code{k} (\code{q x q}) covariance matrices.}
#'   \item{\code{phi}: }{A (\code{q x qp}) matrix of autoregressive coefficients.}
#'   \item{\code{p}: }{Number of autoregressive lags.}
#'   \item{\code{q}: }{Number of series.}
#'   \item{\code{P}: }{A (\code{k x k}) transition matrix (columns must sum to one).}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated vector autoregressive series and its DGP parameters.
#' 
#' @example /inst/examples/simuMSVAR_examples.R
#' @export
simuMSVAR <- function(mdl_h0, burnin = 100L) {
    .Call(`_MSTest_simuMSVAR`, mdl_h0, burnin)
}

#' @title Simulate normally distributed process
#' 
#' @description This function simulates a normally distributed process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{mu}: }{A (\code{q x 1}) vector of means.}
#'   \item{\code{sigma}: }{A (\code{q x q}) covariance matrix.}
#'   \item{\code{q}: }{Number of series.}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated series and its DGP parameters.
#' 
#' @example /inst/examples/simuNorm_examples.R
#' @export
simuNorm <- function(mdl_h0, burnin = 0L) {
    .Call(`_MSTest_simuNorm`, mdl_h0, burnin)
}

#' @title Simulate Hidden Markov model with normally distributed errors
#' 
#' @description This function simulates a Hidden Markov Model process.
#' 
#' @param mdl_h0 List containing the following DGP parameters
#' \itemize{
#'   \item{\code{n}: }{Length of series.}
#'   \item{\code{k}: }{Number of regimes.}
#'   \item{\code{mu}: }{A (\code{k x q}) vector of means.}
#'   \item{\code{sigma}: }{A (\code{q x q}) covariance matrix.}
#'   \item{\code{q}: }{Number of series.}
#'   \item{\code{P}: }{A (\code{k x k}) transition matrix (columns must sum to one).}
#'   \item{\code{eps}: }{An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.}
#' }
#' @param burnin Number of simulated observations to remove from beginning. Default is \code{100}.
#' 
#' @return List with simulated series and its DGP parameters.
#' 
#' @example /inst/examples/simuHMM_examples.R
#' @export
simuHMM <- function(mdl_h0, burnin = 100L) {
    .Call(`_MSTest_simuHMM`, mdl_h0, burnin)
}

#' @title Normal log-likelihood objective function 
#' 
#' @description This function computes the log-likelihood for a normally distributed model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' 
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_Nmdl <- function(theta, mdl) {
    .Call(`_MSTest_logLike_Nmdl`, theta, mdl)
}

#' @title Autoregressive log-likelihood objective function
#' 
#' @description This function computes the log-likelihood for an autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' 
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_ARmdl <- function(theta, mdl) {
    .Call(`_MSTest_logLike_ARmdl`, theta, mdl)
}

#' @title Vector autoregressive log-likelihood objective function 
#' 
#' @description This function computes the log-likelihood for a vector autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' 
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_VARmdl <- function(theta, mdl) {
    .Call(`_MSTest_logLike_VARmdl`, theta, mdl)
}

#' @title Hidden Markov model log-likelihood function 
#' 
#' @description This function computes the log-likelihood for a markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_HMmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_HMmdl`, theta, mdl, k)
}

#' @title Hidden Markov model log-likelihood function  (minimization version)
#' 
#' @description This function computes the (negative) log-likelihood for a markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} integer determining the number of regimes.
#' 
#' @return Negative log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_HMmdl_min <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_HMmdl_min`, theta, mdl, k)
}

#' @title Markov-switching autoregressive log-likelihood objective function
#' 
#' @description This function computes the log-likelihood for a markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_MSARmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_MSARmdl`, theta, mdl, k)
}

#' @title Markov-switching autoregressive log-likelihood objective function (minimization version)
#' 
#' @description This function computes the (negative) log-likelihood for a markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} integer determining the number of regimes.
#' 
#' @return Negative log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_MSARmdl_min <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_MSARmdl_min`, theta, mdl, k)
}

#' @title Markov-switching vector autoregressive log-likelihood objective function
#' 
#' @description This function computes the log-likelihood for a markov-switching vector autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return Log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_MSVARmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_MSVARmdl`, theta, mdl, k)
}

#' @title Markov-switching vector autoregressive log-likelihood objective function (minimization version)
#' 
#' @description This function computes the (negative) log-likelihood for a markov-switching vector autoregressive model
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return Negative log-likelihood value.
#' 
#' @keywords internal
#' 
#' @export
logLike_MSVARmdl_min <- function(theta, mdl, k) {
    .Call(`_MSTest_logLike_MSVARmdl_min`, theta, mdl, k)
}

#' @title Hidden Markov model log-likelihood function 
#' 
#' @description This function computes the log-likelihood for a Hidden Markov model and uses the Hamilton smoother to obtain smoothed probabilities of each state. This is also the expectation step in the Expectation Maximization algorithm for a Markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return List which includes log-likelihood value and smoothed probabilities of each regime.
#' 
#' @keywords internal
#' 
#' @export
ExpectationM_HMmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_ExpectationM_HMmdl`, theta, mdl, k)
}

#' @title Markov-switching autoregressive log-likelihood function 
#' 
#' @description This function computes the log-likelihood for a markov-switching autoregressive model and uses the Hamilton smoother to obtain smoothed probabilities of each state. This is also the expectation step in the Expectation Maximization algorithm for a Markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return List which includes log-likelihood and smoothed probabilities of each regime.
#' 
#' @keywords internal
#' 
#' @export
ExpectationM_MSARmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_ExpectationM_MSARmdl`, theta, mdl, k)
}

#' @title Markov-switching vector autoregressive log-likelihood function
#' 
#' @description This function computes the log-likelihood for a markov-switching vector autoregressive model and uses the Hamilton smoother to obtain smoothed probabilities of each state. This is also the expectation step in the Expectation Maximization algorithm for a Markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return List which includes log-likelihood and smoothed probabilities of each regime.
#' 
#' @keywords internal
#' 
#' @export
ExpectationM_MSVARmdl <- function(theta, mdl, k) {
    .Call(`_MSTest_ExpectationM_MSVARmdl`, theta, mdl, k)
}

#' @title Maximization step of EM algorithm for Hidden Markov model
#' 
#' @description This function performs the maximization step of the Expectation Maximization algorithm for Hidden Markov models.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{MSloglik_output} List with output from \code{\link{ExpectationM_HMmdl}}.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return List with new maximized parameters.
#' 
#' @keywords internal
#' 
#' @export
EMaximization_HMmdl <- function(theta, mdl, MSloglik_output, k) {
    .Call(`_MSTest_EMaximization_HMmdl`, theta, mdl, MSloglik_output, k)
}

#' @title Maximization step of EM algorithm for Markov-switching autoregressive model
#' 
#' @description This function performs the maximization step of the Expectation Maximization algorithm for Markov-switching autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{MSloglik_output} List with output from \code{\link{ExpectationM_MSARmdl}}.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return List with new maximized parameters.
#' 
#' @keywords internal
#' 
#' @export
EMaximization_MSARmdl <- function(theta, mdl, MSloglik_output, k) {
    .Call(`_MSTest_EMaximization_MSARmdl`, theta, mdl, MSloglik_output, k)
}

#' @title Maximization step of EM algorithm for Markov-switching vector autoregressive model
#' 
#' @description This function performs the maximization step of the Expectation Maximization algorithm for Markov-switching vector autoregressive model.
#' 
#' @param \code{theta} Vector of model parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{MSloglik_output} List with output from \code{\link{ExpectationM_MSVARmdl}}.
#' @param \code{k} Integer determining the number of regimes.
#'  
#' @return List with new maximized parameters.
#' 
#' @keywords internal
#' 
#' @export
EMaximization_MSVARmdl <- function(theta, mdl, MSloglik_output, k) {
    .Call(`_MSTest_EMaximization_MSVARmdl`, theta, mdl, MSloglik_output, k)
}

#' @title EM algorithm iteration for Hidden Markov model
#' 
#' @description This function performs the one iteration (E-step and M-step) of the Expectation Maximization algorithm for a Hidden Markov model.
#' 
#' @param \code{mdl} List with model attributes.
#' @param \code{EMest_output} List with attributes from previous iteration.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return List with attributes from new iteration.
#' 
#' @keywords internal
#' 
#' @export
EMiter_HMmdl <- function(mdl, EMest_output, k) {
    .Call(`_MSTest_EMiter_HMmdl`, mdl, EMest_output, k)
}

#' @title EM algorithm iteration for Markov-switching autoregressive model
#' 
#' @description This function performs the one iteration (E-step and M-step) of the Expectation Maximization algorithm for Markov-switching autoregressive model.
#' 
#' @param \code{mdl} List with model attributes.
#' @param \code{EMest_output} List with attributes from previous iteration.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return List with attributes from new iteration.
#' 
#' @keywords internal
#' 
#' @export
EMiter_MSARmdl <- function(mdl, EMest_output, k) {
    .Call(`_MSTest_EMiter_MSARmdl`, mdl, EMest_output, k)
}

#' @title EM algorithm iteration for Markov-switching vector autoregressive model
#' 
#' @description This function performs the one iteration (E-step and M-step) of the Expectation Maximization algorithm for Markov-switching vector autoregressive model.
#' 
#' @param \code{mdl} List with model attributes.
#' @param \code{EMest_output} List with attributes from previous iteration.
#' @param \code{k} Integer determining the number of regimes.
#' 
#' @return List with attributes from new iteration.
#' 
#' @keywords internal
#' 
#' @export
EMiter_MSVARmdl <- function(mdl, EMest_output, k) {
    .Call(`_MSTest_EMiter_MSVARmdl`, mdl, EMest_output, k)
}

#' @title Estimation of Hidden Markov model by EM Algorithm 
#' 
#' @description Estimate Hidden Markov model by EM algorithm. This function is used by \code{\link{HMmdl}} which organizes the output and takes raw data as input.
#' 
#' @param \code{theta_0} vector with initial values for parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' @param \code{optim_options} List with optimization options.
#' 
#' @return List with model results.
#' 
#' @references Dempster, A. P., N. M. Laird, and D. B. Rubin. 1977. “Maximum Likelihood from Incomplete Data via the EM Algorithm.” \emph{Journal of the Royal Statistical Society}. Series B 39 (1): 1–38.
#' 
#' @keywords internal
#' 
#' @export
HMmdl_em <- function(theta_0, mdl, k, optim_options) {
    .Call(`_MSTest_HMmdl_em`, theta_0, mdl, k, optim_options)
}

#' @title Estimation of Markov-switching autoregressive model by EM Algorithm 
#' 
#' @description Estimate Markov-switching autoregressive model by EM algorithm. This function is used by \code{\link{MSARmdl}} which organizes the output and takes raw data as input.
#' 
#' @param \code{theta_0} vector with initial values for parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' @param \code{optim_options} List with optimization options.
#' 
#' @return List with model results.
#' 
#' @keywords internal
#' 
#' @references Dempster, A. P., N. M. Laird, and D. B. Rubin. 1977. “Maximum Likelihood from Incomplete Data via the EM Algorithm.” \emph{Journal of the Royal Statistical Society}. Series B 39 (1): 1–38.
#' @references Hamilton, James D. 1990. “Analysis of time series subject to changes in regime.” \emph{Journal of econometrics}, 45 (1-2): 39–70.
#' 
#' @export
MSARmdl_em <- function(theta_0, mdl, k, optim_options) {
    .Call(`_MSTest_MSARmdl_em`, theta_0, mdl, k, optim_options)
}

#' @title Estimation of Markov-switching vector autoregressive model by EM Algorithm 
#' 
#' @description Estimate Markov-switching vector autoregressive model by EM algorithm. This function is used by \code{\link{MSVARmdl}} which organizes the output and takes raw data as input.
#' 
#' @param \code{theta_0} vector with initial values for parameters.
#' @param \code{mdl} List with model attributes.
#' @param \code{k} Integer determining the number of regimes.
#' @param \code{optim_options} List with optimization options.
#' 
#' @return List with model results.
#' 
#' @keywords internal
#' 
#' @references Dempster, A. P., N. M. Laird, and D. B. Rubin. 1977. “Maximum Likelihood from Incomplete Data via the EM Algorithm.” \emph{Journal of the Royal Statistical Society}. Series B 39 (1): 1–38.
#' @references Krolzig, Hans-Martin. 1997. “The markov-switching vector autoregressive model.”. Springer.
#' 
#' @export
MSVARmdl_em <- function(theta_0, mdl, k, optim_options) {
    .Call(`_MSTest_MSVARmdl_em`, theta_0, mdl, k, optim_options)
}

#' @title Test statistic for switch in mean and variance
#'
#' @description This function computes part of the test statistic given by 
#' eq. 2.5 of CHP 2014 when the alternative has switching mean and variance. 
#' The output is used in \code{\link{chpStat}} which computes the full test
#' statistics.
#'
#' @param \code{mdl} List containing model attributes (see \code{\link{ARmdl}}).
#' @param \code{rho_b} Number determining value of \code{rho}.
#' @param \code{ltmt} List containing derivatives output from \code{\link{chpDmat}}.
#' @param \code{hv} Number determining value of \code{h}.
#' 
#' @return Part of test statistic given \code{rho} and \code{hv} value. 
#' 
#' @keywords internal
#' 
#' @references Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal 
#' test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
#' 
#' @export
calc_mu2t_mv <- function(mdl, rho, ltmt, hv) {
    .Call(`_MSTest_calc_mu2t_mv`, mdl, rho, ltmt, hv)
}

#' @title Test statistic for switch in mean only 
#'
#' @description This function computes part of the test statistic given by 
#' eq. 2.5 of CHP 2014 when the alternative has switching mean only. The output 
#' is used in \code{\link{chpStat}} which computes the full test statistics.
#'
#' @param \code{mdl} List containing model attributes (see \code{\link{ARmdl}}).
#' @param \code{rho_b} Number determining value of \code{rho}.
#' @param \code{ltmt} List containing derivatives output from \code{\link{chpDmat}}.
#' 
#' @return Part of test statistic given \code{rho} and \code{hv} value. 
#' 
#' @keywords internal
#' 
#' @references Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
#' 
#' @export
calc_mu2t <- function(mdl, rho, ltmt) {
    .Call(`_MSTest_calc_mu2t`, mdl, rho, ltmt)
}

#' @title Test statistic for CHP 2014 parameter stability test
#' 
#' @description This function computes the supTS and expTS test-statistics 
#' proposed in CHP 2014.
#'
#' @param \code{mdl} List containing model attributes (see \code{\link{ARmdl}}).
#' @param \code{rho_b} Number determining bounds for distribution of \code{rh0} (i.e. \code{rho} ~ \code{[-rho_b,rho_b]}).
#' @param \code{ltmt} List containing derivatives output from \code{\link{chpDmat}}.
#' @param \code{msvar} Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered.
#' 
#' @return A (\code{2 x 1}) vector with supTS test statistic as first element and expTS test-statistics as second element.
#' 
#' @keywords internal
#' 
#' @references Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal 
#' test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
#' 
#' @export
chpStat <- function(mdl, rho_b, ltmt, msvar) {
    .Call(`_MSTest_chpStat`, mdl, rho_b, ltmt, msvar)
}

#' @title Bootstrap critical values for CHP 2014 parameter stability test
#'
#' @description This bootstrap procedure is described on pg. 771 of CHP 2014.
#'
#'
#' @param \code{mdl} List containing model attributes (see \code{\link{ARmdl}}).
#' @param \code{rho_b} Number determining bounds for distribution of \code{rh0} (i.e. \code{rho} ~ \code{[-rho_b,rho_b]}).
#' @param \code{N} Number of bootstrap simulations.
#' @param \code{msvar} Boolean indicator. If \code{TRUE}, there is a switch in variance. If \code{FALSE} only switch in mean is considered.
#' 
#' @return Bootstrap critical values
#' 
#' @keywords internal
#' 
#' @references Carrasco, Marine, Liang Hu, and Werner Ploberger. 2014. “Optimal 
#' test for Markov switching parameters.” \emph{Econometrica} 82 (2): 765–784.
#' 
#' @export
bootCV <- function(mdl, rho_b, N, msvar) {
    .Call(`_MSTest_bootCV`, mdl, rho_b, N, msvar)
}

#' @title Likelihood ratio test statistic sample distribution
#' 
#' @description This function is used by Monte Carlo Likelihood ratio testing 
#' procedures to simulate processes under the null hypothesis.
#' 
#' @param mdl_h0 List with restricted model properties.
#' @param p integer specifying the number of autoregressive lags.
#' @param q integer specifying the number of series.
#' @param k integer specifying the number of regimes.
#' @param burnin integer specifying the number of observations to drop from beginning of simulation.
#' 
#' @return List with simulated process properties. 
#' 
#' @keywords internal
#' 
#' @export
simuMdl <- function(mdl_h0, p, q, k, burnin) {
    .Call(`_MSTest_simuMdl`, mdl_h0, p, q, k, burnin)
}

#' @title Change model List with new parameters
#' 
#' @description This function is used by the MMC LRT procedure. It makes a 
#' copy of the restricted model under the null hypothesis and changes the 
#' parameters used to simulate the process under the null with values being 
#' considered in the search/optimization. 
#' 
#' @param mdl_h0 List with restricted model properties.
#' @param theta_h0 vector of parameter values under null being considered.
#' @param p integer specifying the number of autoregressive lags.
#' @param q integer specifying the number of series.
#' @param k integer specifying the number of regimes.
#' 
#' @return List with model properties
#' 
#' @keywords internal
#' 
#' @export
mdledit <- function(mdl_h0, theta_h0, p, q, k0) {
    .Call(`_MSTest_mdledit`, mdl_h0, theta_h0, p, q, k0)
}

#' @title Computes test stat using new parameter vectors
#' 
#' @description This function computes the LRT statistic.
#' 
#' @param theta_h0 estimated parameter values for restricted model.
#' @param mdl_h0 List with restricted model properties.
#' @param LT_h1 Double specifying maximum log likelihood under alternative.
#' @param p integer specifying the number of autoregressive lags.
#' @param q integer specifying the number of series.
#' @param k0 integer specifying the number of regimes under the null hypothesis.
#' 
#' @return LRT statistic
#' 
#' @keywords internal
#' 
#' @export
compu_tstat <- function(theta_h0, mdl_h0, LT_h1, p, q, k0) {
    .Call(`_MSTest_compu_tstat`, theta_h0, mdl_h0, LT_h1, p, q, k0)
}

#' @title Likelihood Ratio Test Statistic Sample Distribution
#' 
#' @description This function simulates the sample distribution under the null hypothesis.
#' 
#' @param mdl_h0 List with restricted model properties.
#' @param k1 integer specifying the number of regimes under the alternative hypothesis.
#' @param N integer specifying the number of replications.
#' @param burnin integer specifying the number of observations to drop from beginning of simulation.
#' @param mdl_h0_control List with controls/options used to estimate restricted model.
#' @param mdl_h1_control List with controls/options used to estimate unrestricted model.
#' 
#' @return vector of simulated LRT statistics
#' 
#' @keywords internal
#' 
#' @references Rodriguez Rondon, Gabriel and Jean-Marie Dufour. 2022. "Simulation-Based Inference for Markov Switching Models” \emph{JSM Proceedings, Business and Economic Statistics Section: American Statistical Association}.
#' @references Rodriguez Rondon, Gabriel and Jean-Marie Dufour. 2022. “Monte Carlo Likelihood Ratio Tests for Markov Switching Models.” \emph{Unpublished manuscript}.
#' 
#' @export
LR_samp_dist <- function(mdl_h0, k1, N, burnin, mdl_h0_control, mdl_h1_control) {
    .Call(`_MSTest_LR_samp_dist`, mdl_h0, k1, N, burnin, mdl_h0_control, mdl_h1_control)
}

#' @title Monte Carlo Likelihood Ratio Test P-value Function 
#' 
#' @description This function computes the Maximum Monte Carlo P-value.
#' 
#' @param theta_h0 vector of parameter values under the null being considered.
#' @param mdl_h0 List with restricted model properties.
#' @param k1 integer determining the number of regimes under the alternative.
#' @param LT_h1 double specifying maximum log likelihood under alternative.
#' @param N integer specifying the number of replications.
#' @param burnin integer specifying the number of observations to drop from beginning of simulation.
#' @param workers Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open.
#' @param lambda Double determining penalty on nonlinear constraint.
#' @param stationary_constraint Boolean determining if only stationary solutions are considered (if \code{TRUE}) or not (if \code{FALSE}).
#' @param thtol double determining the convergence criterion used during estimation.
#' @param mdl_h0_control List with controls/options used to estimate restricted model.
#' @param mdl_h1_control List with controls/options used to estimate unrestricted model.
#' 
#' @return MMC p-value
#' 
#' @keywords internal
#' 
#' @export
MMCLRpval_fun <- function(theta_h0, mdl_h0, k1, LT_h1, N, burnin, workers, lambda, stationary_constraint, thtol, mdl_h0_control, mdl_h1_control) {
    .Call(`_MSTest_MMCLRpval_fun`, theta_h0, mdl_h0, k1, LT_h1, N, burnin, workers, lambda, stationary_constraint, thtol, mdl_h0_control, mdl_h1_control)
}

#' @title Monte Carlo Likelihood Ratio Test P-value Function 
#' 
#' @description This function computes the (negative) Maximum Monte Carlo P-value.
#' 
#' @param theta vector of parameter values being considered.
#' @param mdl_h0 List with restricted model properties.
#' @param k1 integer determining the number of regimes under the alternative.
#' @param LT_h1 double specifying maximum log likelihood under alternative.
#' @param N integer specifying the number of replications.
#' @param burnin integer specifying the number of observations to drop from beginning of simulation.
#' @param workers Integer determining the number of workers to use for parallel computing version of test. Note that parallel pool must already be open.
#' @param lambda Double determining penalty on nonlinear constraint.
#' @param stationary_constraint Boolean determining if only stationary solutions are considered (if \code{TRUE}) or not (if \code{FALSE}).
#' @param thtol double determining the convergence criterion used during estimation.
#' @param mdl_h0_control List with controls/options used to estimate restricted model.
#' @param mdl_h1_control List with controls/options used to estimate unrestricted model.
#' 
#' @return negative MMC p-value
#' 
#' @keywords internal
#' 
#' @export
MMCLRpval_fun_min <- function(theta, mdl_h0, k1, LT_h1, N, burnin, workers, lambda, stationary_constraint, thtol, mdl_h0_control, mdl_h1_control) {
    .Call(`_MSTest_MMCLRpval_fun_min`, theta, mdl_h0, k1, LT_h1, N, burnin, workers, lambda, stationary_constraint, thtol, mdl_h0_control, mdl_h1_control)
}

#' @title Moment-based test statistics 
#'
#' @description This function computes the four moment-based test statistics (eq. \code{11} - \code{14}) discussed in Dufour & Luger 2017.
#'
#' @param \code{ehat} A (\code{T x 1}) vector of restricted model residuals.
#' 
#' @return Vector containing the four test statistics.
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export
calc_DLmoments <- function(ehat) {
    .Call(`_MSTest_calc_DLmoments`, ehat)
}

#' @title Simulated moment-based test statistics
#'
#' @description This function computes the four moment-based test statistics (eq. \code{11} - \code{14}) discussed in Dufour & Luger 2017 for \code{N} different simulated series.
#' 
#' @param \code{Tsize} Length of sample size for simulation.
#' @param \code{N} Number of simulated samples.
#' 
#' @return A (\code{N x 4}) matrix with \code{N} different simulated moment-based test statistics.
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export
sim_DLmoments <- function(Tsize, N) {
    .Call(`_MSTest_sim_DLmoments`, Tsize, N)
}

#' @title Combine p-values 
#'
#' @description This function is used to combine the four moment-based p-values as in eq. \code{17} and \code{18} of Dufour & Luger 2017.
#' 
#' @param \code{stats} A (\code{l x 4}) matrix where \code{l} is the number of moment-based test statistics.
#' @param \code{param} A (\code{2 x 4}) matrix with parameters to combine test statistics. See \code{\link{approxDistDL}}.
#' @param \code{type} String determining the type of method used to combine p-values. If set to "min" the min method of combining p-values 
#' is used as in Fisher 1932 and Pearson 1933. If set to "prod" the product of p-values is used as in Tippett 1931 and Wilkinson 1951.
#' 
#' @return A (\code{N x 1}) vector with test statistics. The last element is the test statistic from observed data.
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' @references Tippett, L. 1931. "The Method of Statistics". London: Williams & Norgate.
#' @references Wilkinson, B. 1951. "A statistical consideration in psychological research." \emph{Psychology Bulletin} 48:156–158.
#' @references Pearson, K. 1933. "On a method of determining whether a sample of size n
#'  supposed to have been drawn from a parent population having a known probability integral has probably been drawn at random". \emph{Biometrika} 25:379–410.
#' @references Fisher, R. 1932. "Statistical Methods for Research Workers." Edinburgh: Oliver and Boyd.
#' 
#' @export
combine_stat <- function(stats, params, type) {
    .Call(`_MSTest_combine_stat`, stats, params, type)
}

#' @title Loop for \code{\link{approxDistDL}}
#'
#' @description This function performs the loop in required in \code{\link{approxDistDL}}. 
#' 
#' @param \code{SN2} A (\code{T x 4}) matrix of  test-statistics.
#' 
#' @return The test statistics from simulated data. Used for NLS to get \code{params} needed to combine p-values.
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export    
approx_dist_loop <- function(SN2) {
    .Call(`_MSTest_approx_dist_loop`, SN2)
}

#' @title Moment-based MMC test p-value 
#'
#' @description This functions is used by numerical optimization algorithms for find maximum p-value given parameter vector \code{theta}.
#'
#' @param theta Value of nuisance parameters. Specifically, these are the consistent estimates of nuisance parameters as discussed in Dufour & Luger (2017) LMC procedure.
#' @param y series being tested.
#' @param x lagged values of series.
#' @param params A (\code{2 x 4}) matrix with parameters to combine test statistics. See \code{\link{approxDistDL}}.
#' @param sim_stats A (\code{N x 1}) vector with test statistics. The last element is the test statistic from observed data.
#' @param pval_type String determining the type of method used to combine p-values. If set to "min" the min method of combining p-values is used as in Fisher 1932 and Pearson 1933. If set to "prod" the product of p-values is used as in Tippett 1931 and Wilkinson 1951.
#' @param stationary_ind Boolean indicator determining if only stationary solutions should be considered if \code{TRUE} or any solution can be considered if \code{FALSE}. Default is \code{TRUE}.
#' @param lambda Numeric value for penalty on stationary constraint not being met. Default is \code{100}.
#' 
#' @return Maximized Monte Carlo p-value.
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export
DLMMCpval_fun <- function(theta, y, x, params, sim_stats, pval_type, stationary_ind, lambda) {
    .Call(`_MSTest_DLMMCpval_fun`, theta, y, x, params, sim_stats, pval_type, stationary_ind, lambda)
}

#' @title Moment-based MMC test (negative) p-value 
#'
#' @description This functions is used by numerical optimization algorithms for find negative of maximum p-value given parameter vector \code{theta}.
#'
#' @param theta Value of nuisance parameters. Specifically, these are the consistent estimates of nuisance parameters as discussed in Dufour & Luger (2017) LMC procedure.
#' @param y series being tested.
#' @param x lagged values of series.
#' @param params A (\code{2 x 4}) matrix with parameters to combine test statistics. See \code{\link{approxDistDL}}.
#' @param sim_stats A (\code{N x 1}) vector with test statistics. The last element is the test statistic from observed data.
#' @param pval_type String determining the type of method used to combine p-values. If set to "min" the min method of combining p-values is used as in Fisher 1932 and Pearson 1933. If set to "prod" the product of p-values is used as in Tippett 1931 and Wilkinson 1951.
#' @param stationary_ind Boolean indicator determining if only stationary solutions should be considered if \code{TRUE} or any solution can be considered if \code{FALSE}. Default is \code{TRUE}.
#' @param lambda Numeric value for penalty on stationary constraint not being met. Default is \code{100}.
#'
#' @return Negative Maximized Monte Carlo p-value. 
#' 
#' @keywords internal
#' 
#' @references Dufour, J. M., & Luger, R. 2017. "Identification-robust moment-based 
#' tests for Markov switching in autoregressive models." \emph{Econometric Reviews}, 36(6-9), 713-727.
#' 
#' @export
DLMMCpval_fun_min <- function(theta, y, x, params, sim_stats, pval_type, stationary_ind, lambda) {
    .Call(`_MSTest_DLMMCpval_fun_min`, theta, y, x, params, sim_stats, pval_type, stationary_ind, lambda)
}

