% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_statistics.R
\name{compute_statistics}
\alias{compute_statistics}
\title{Calculates the value of the test statistics both for single time series
analysis and multiple time series analysis.}
\usage{
compute_statistics(
  data,
  sigma = 1,
  sigma_vec = 1,
  n_ts = 1,
  grid = NULL,
  ijset = NULL,
  deriv_order = 0,
  epidem = FALSE
)
}
\arguments{
\item{data}{Vector (in case of n_ts = 1) or matrix (in case of
n_ts > 1) that contains (a number of) time series
that needs to be analyzed. In the latter case,
each column of the matrix must contain one time series.}

\item{sigma}{The estimator of the square root of the long-run
variance \eqn{\sigma} in case of n_ts = 1,
or the estimator of the overdispersion parameter
\eqn{\sigma} in case of n_ts > 1 and epidemic = TRUE.}

\item{sigma_vec}{Vector that consists of estimators of the square root
of the long-run variances \eqn{\sigma_i} in case of
n_ts > 1 and epidemic = FALSE.}

\item{n_ts}{Number of time series analysed. Default is 1.}

\item{grid}{Grid of location-bandwidth points as produced by
the functions \code{\link{construct_grid}} or
\code{\link{construct_weekly_grid}}, it is a list with
the elements 'gset', 'bws', 'gtype'. If not provided,
then the defalt grid is used.
For the construction of the default grid,
see \code{\link{construct_grid}}.}

\item{ijset}{In case of multiple time series (n_ts > 1),
we need to know which pairs of time series to compare.
This matrix consists of all pairs of indices \eqn{(i, j)}
that we want to compare. If not provided, then all
possible pairwise comparison are performed.}

\item{deriv_order}{In case of a single time series, this denotes the order of
the derivative of the trend that we estimate.
Default is 0.}

\item{epidem}{Logical variable, TRUE if we are using
dealing with epidemic time trends. Default is FALSE.}
}
\value{
In case of n_ts = 1, the function returns a list
with the following elements:
\item{stat}{Value of the multiscale statistics.}
\item{gset_with_vals}{A matrix that contains the values of the normalised 
                        kernel averages for each pair of location-bandwidth
                        with the corresponding location and bandwidth.}
                        
In case of n_ts > 1, the function returns a list
with the following elements:
\item{stat}{Value of the multiscale statistics.}
\item{stat_pairwise}{Matrix of the values of the pairwise statistics.}
\item{ijset}{The matrix that  consists of all pairs of indices
                        \eqn{(i, j)} that we compared. The order of these
                        pairs corresponds to the order in the list
                        gset_with_vals.}
\item{gset_with_vals}{A list of matrices, each matrix corresponding to a 
                        specific pairwise comparison. The order of the list 
                        is determined by ijset. Each matrix contains
                        the values of the normalisedkernel averages
                        for each pair of location-bandwidth
                        with the corresponding location and bandwidth.}
}
\description{
Calculates the value of the test statistics both for single time series
analysis and multiple time series analysis.
}
