% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bidev.R
\name{plot_bidev}
\alias{plot_bidev}
\title{Plot Multiscalar Typology (2 deviations)}
\usage{
plot_bidev(
  x,
  dev1,
  dev2,
  breaks = c(25, 50, 100),
  dev1.lab = NULL,
  dev2.lab = NULL,
  lib.var = NULL,
  lib.val = NULL,
  cex.lab = 1,
  cex.axis = 0.7,
  cex.pt = 0.5,
  cex.names = 0.8,
  pos.names = 4
)
}
\arguments{
\item{x}{a sf object or a dataframe including 2 pre-calculated deviations.}

\item{dev1}{column name of the first relative deviation in x.}

\item{dev2}{coumn name of the second relative deviation in x.}

\item{breaks}{distance to the index 100 (average of the context), in
percentage. A vector of three values. Defaut c(25,50,100). 25 % corresponds
to indexes 80 and 125. 50 % to indexes 67 and 150 and 100 % to indexes 50 
and 200.}

\item{dev1.lab}{label to be put in x-axis of the scatter plot (default: NULL).}

\item{dev2.lab}{label to be put in y-axis of the scatter plot (default: NULL).}

\item{lib.var}{column name of x including territorial units name/code we
want to display on the plot.}

\item{lib.val}{a vector of territorial units included in lib.label we want
to display on the plot.}

\item{cex.lab}{size of the axis label text (default = 1).}

\item{cex.axis}{size of the tick label numbers (default = 0.7).}

\item{cex.pt}{size of the dot used for extract specific territorial units 
(default 0.5).}

\item{cex.names}{size of the territorial units labels if selected 
(default 0.8).}

\item{pos.names}{position of territorial units labels (default 4, to the right).}
}
\value{
A scatter-plot displaying the 13 bidev categories, which are the synthesis
of the position of territorial units according to 2 deviations and their
respective distance to the average. X-Y axis are expressed in logarithm 
(25 % above the average corresponding to index 125 and 25 % below the average
being index 80). 
\itemize{bidev typology values :
\item{ZZ: Near the average for the two selected deviation, in grey}
\item{A1: Above the average for dev1 and dev2, distance to the avarage : +,
in light red}
\item{A2: Above the average for dev1 and dev2, distance to the avarage : ++,
in red}
\item{A3: Above the average for dev1 and dev2, distance to the avarage : +++,
in dark red}
\item{B1: Above the average for dev1 and below for dev2, distance to the
 avarage : +, in light yellow}
\item{B2: Above the average for dev1 and below for dev2, distance to the
 avarage : ++, in yellow}
\item{B3: Above the average for dev1 and below for dev2, distance to the
 avarage : +++, in dark yellow}
\item{C1: Below the average for dev1 and dev2, distance to the avarage : +,
in light blue}
\item{C2: Below the average for dev1 and dev2, distance to the avarage : ++,
in blue}
\item{C3: Below the average for dev1 and dev2, distance to the avarage : +++,
in dark blue}
\item{D1: Below the average for dev1 and above for dev2, distance to the
 avarage : +, in light green}
\item{D2: Below the average for dev1 and above for dev2, distance to the
 avarage : ++, in green}
\item{D3: Below the average for dev1 and above for dev2, distance to the
 avarage : +++, in dark green}
}
}
\description{
Vizualizing bidev and select some territorial units on it.
}
\examples{
# Load data
library(sf)
com <- st_read(system.file("metroparis.gpkg", package = "MTA"), layer = "com", quiet = TRUE)

# Prerequisite  - Compute 2 deviations
com$gdev <- gdev(x = com, var1 = "INC", var2 = "TH")
com$tdev <- tdev(x = com, var1 = "INC", var2 = "TH", key = "EPT")

# EX1 standard breaks with four labels
plot_bidev(x = com, 
           dev1 = "gdev", 
           dev2 = "tdev",
           dev1.lab = "General deviation (MGP Area)",
           dev2.lab = "Territorial deviation (EPT of belonging)",
           lib.var = "LIBCOM",
           lib.val =  c("Marolles-en-Brie", "Suresnes", 
                        "Clichy-sous-Bois", "Les Lilas"))

# EX2, change breaks, enlarge breaks 
plot_bidev(x = com,
           breaks = c(75, 150, 300),
           dev1 = "gdev", 
           dev2 = "tdev", 
           dev1.lab = "General deviation (MGP Area)",
           dev2.lab = "Territorial deviation (EPT of belonging)")
}
