% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_AdaBoostModel.R
\name{AdaBoostModel}
\alias{AdaBoostModel}
\title{Boosting with Classification Trees}
\usage{
AdaBoostModel(boos = TRUE, mfinal = 100, coeflearn = c("Breiman",
  "Freund", "Zhu"), minsplit = 20, minbucket = round(minsplit/3),
  cp = 0.01, maxcompete = 4, maxsurrogate = 5, usesurrogate = 2,
  xval = 10, surrogatestyle = 0, maxdepth = 30)
}
\arguments{
\item{boos}{if \code{TRUE}, then bootstrap samples are drawn from the
training set using the observation weights at each iteration.  If
\code{FALSE}, then all observations are used with their weights.}

\item{mfinal}{number of iterations for which boosting is run.}

\item{coeflearn}{learning algorithm.}

\item{minsplit}{minimum number of observations that must exist in a node in
order for a split to be attempted.}

\item{minbucket}{minimum number of observations in any terminal node.}

\item{cp}{complexity parameter.}

\item{maxcompete}{number of competitor splits retained in the output.}

\item{maxsurrogate}{number of surrogate splits retained in the output.}

\item{usesurrogate}{how to use surrogates in the splitting process.}

\item{xval}{number of cross-validations.}

\item{surrogatestyle}{controls the selection of a best surrogate.}

\item{maxdepth}{maximum depth of any node of the final tree, with the root
node counted as depth 0.}
}
\value{
\code{MLModel} class object.
}
\description{
Fits the AdaBoost.M1 (Freund and Schapire, 1996) and SAMME (Zhu et al., 2009)
algorithms using classification trees as single classifiers.
}
\details{
\describe{
\item{Response Types:}{\code{factor}}
}

Further model details can be found in the source link below.
}
\examples{
fit(Species ~ ., data = iris, model = AdaBoostModel(mfinal = 5))

}
\seealso{
\code{\link[adabag]{boosting}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
