% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff}
\alias{diff}
\alias{diff.ModelMetrics}
\alias{diff.Resamples}
\alias{diff.MLModelTune}
\title{Model Performance Differences}
\usage{
\method{diff}{ModelMetrics}(x, ...)

\method{diff}{Resamples}(x, ...)

\method{diff}{MLModelTune}(x, ...)
}
\arguments{
\item{x}{object containing resampled metrics.}

\item{...}{arguments to be passed to other methods.}
}
\value{
\code{ModelMetricsDiff} class object that inherits from
\code{ModelMetrics}.
}
\description{
Pairwise model differences in resampled performance metrics.
}
\examples{
## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
control <- CVControl()

gbmres1 <- resample(fo, Melanoma, GBMModel(n.trees = 25), control)
gbmres2 <- resample(fo, Melanoma, GBMModel(n.trees = 50), control)
gbmres3 <- resample(fo, Melanoma, GBMModel(n.trees = 100), control)

res <- Resamples(GBM1 = gbmres1, GBM2 = gbmres2, GBM3 = gbmres3)
perfdiff <- diff(res)
summary(perfdiff)
plot(perfdiff)

}
\seealso{
\code{\link{modelmetrics}}, \code{\link{resample}},
\code{\link{tune}}, \code{\link{plot}}, \code{\link{summary}},
\code{\link{t.test}}
}
