% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_BlackBoostModel.R
\name{BlackBoostModel}
\alias{BlackBoostModel}
\title{Gradient Boosting with Regression Trees}
\usage{
BlackBoostModel(family = NULL, mstop = 100, nu = 0.1,
  risk = c("inbag", "oobag", "none"), stopintern = FALSE,
  trace = FALSE, teststat = c("quadratic", "maximum"),
  testtype = c("Teststatistic", "Univariate", "Bonferroni",
  "MonteCarlo"), mincriterion = 0, minsplit = 10, minbucket = 4,
  maxdepth = 2, saveinfo = FALSE, ...)
}
\arguments{
\item{family}{\code{\link[mboost]{Family}} object.  Set automatically
according to the class type of the response variable.}

\item{mstop}{number of initial boosting iterations.}

\item{nu}{step size or shrinkage parameter between 0 and 1.}

\item{risk}{method to use in computing the empirical risk for each boosting
iteration.}

\item{stopintern}{logical inidicating whether the boosting algorithm stops
internally when the out-of-bag risk increases at a subsequent iteration.}

\item{trace}{logical indicating whether status information is printed during
the fitting process.}

\item{teststat}{type of the test statistic to be applied for variable
selection.}

\item{testtype}{how to compute the distribution of the test statistic.}

\item{mincriterion}{value of the test statistic or 1 - p-value that must be
exceeded in order to implement a split.}

\item{minsplit}{minimum sum of weights in a node in order to be considered
for splitting.}

\item{minbucket}{minimum sum of weights in a terminal node.}

\item{maxdepth}{maximum depth of the tree.}

\item{saveinfo}{logical indicating whether to store information about
variable selection in \code{info} slot of each \code{partynode}.}

\item{...}{additional arguments to \code{\link[partykit]{ctree_control}}.}
}
\value{
\code{MLModel} class object.
}
\description{
Gradient boosting for optimizing arbitrary loss functions where regression
trees are utilized as base-learners.
}
\details{
\describe{
\item{Response Types:}{\code{binary}, \code{numeric}, \code{Surv}}
\item{\link[=tune]{Automatic Tuning} Grid Parameters:}{
  \code{mstop}, \code{maxdepth}
}
}

Default values for the \code{NULL} arguments and further model details can be
found in the source links below.
}
\examples{
library(MASS)

fit(type ~ ., data = Pima.tr, model = BlackBoostModel())

}
\seealso{
\code{\link[mboost]{blackboost}}, \code{\link[mboost]{Family}},
\code{\link[partykit]{ctree_control}}, \code{\link{fit}},
\code{\link{resample}}, \code{\link{tune}}
}
