% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_TunedModel.R
\name{TunedModel}
\alias{TunedModel}
\title{Tuned Model}
\usage{
TunedModel(model, grid = 3, fixed = NULL, control = CVControl,
  metrics = NULL, stat = base::mean, cutoff = NULL)
}
\arguments{
\item{model}{\code{MLModel} function, function name, or object to be tuned.}

\item{grid}{\code{data.frame} containing parameter values at which to
evaluate a single model supplied to \code{models}, the number of
parameter-specific values to generate automatically if the model has a
pre-defined grid, or a call to \code{\link{Grid}}.  Ignored in the case of a
list of models.}

\item{fixed}{list of fixed parameter values to combine with those in
\code{grid}.}

\item{control}{\code{\link{MLControl}} object, control function, or character
string naming a control function defining the resampling method to be
employed.}

\item{metrics}{function, one or more function names, or list of named
functions representing performance metrics to be calculated.  If not
specified, default metrics defined in the \code{\link{performance}}
functions are used.  Model tuning is based on the first calculated metric.}

\item{stat}{function to compute a summary statistic on resampled values of
the metric for model tuning.}

\item{cutoff}{argument passed to the \code{metrics} functions.}
}
\value{
\code{TunedModel} class object that inherits from \code{MLModel}.
}
\description{
Model tuned over a grid of parameter values, as produced by the
\code{\link{tune}} function.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}, \code{ordered},
\code{Surv}
}
}
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = TunedModel(GLMNetModel))

}
\seealso{
\code{\link{tune}}, \code{\link{fit}}, \code{\link{resample}}
}
