% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_NNetModel.R
\name{NNetModel}
\alias{NNetModel}
\title{Neural Network Model}
\usage{
NNetModel(
  size = 1,
  linout = FALSE,
  entropy = NULL,
  softmax = NULL,
  censored = FALSE,
  skip = FALSE,
  rang = 0.7,
  decay = 0,
  maxit = 100,
  trace = FALSE,
  MaxNWts = 1000,
  abstol = 1e-04,
  reltol = 1e-08
)
}
\arguments{
\item{size}{number of units in the hidden layer.}

\item{linout}{switch for linear output units.}

\item{entropy}{switch for entropy (= maximum conditional likelihood) fitting.}

\item{softmax}{switch for softmax (log-linear model) and maximum conditional
likelihood fitting.}

\item{censored}{a variant on softmax, in which non-zero targets mean possible
classes.}

\item{skip}{switch to add skip-layer connections from input to output.}

\item{rang}{Initial random weights on [\code{-rang}, \code{rang}].}

\item{decay}{parameter for weight decay.}

\item{maxit}{maximum number of iterations.}

\item{trace}{switch for tracing optimization.}

\item{MaxNWts}{maximum allowable number of weights.}

\item{abstol}{stop if the fit criterion falls below \code{abstol}, indicating
an essentially perfect fit.}

\item{reltol}{stop if the optimizer is unable to reduce the fit criterion by
a factor of at least \code{1 - reltol}.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit single-hidden-layer neural network, possibly with skip-layer connections.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{size}, \code{decay}
  }
}

Default values for the \code{NULL} arguments and further model details can be
found in the source link below.
}
\examples{
fit(sale_amount ~ ., data = ICHomes, model = NNetModel)

}
\seealso{
\code{\link[nnet]{nnet}}, \code{\link{fit}}, \code{\link{resample}}
}
