% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrainedModelFrames.R
\name{SelectedModelFrame}
\alias{SelectedModelFrame}
\alias{SelectedFormula}
\alias{SelectedMatrix}
\title{Selected Model Frame}
\usage{
SelectedFormula(
  ...,
  data,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.Train"),
  cutoff = MachineShop::settings("cutoff")
)

SelectedMatrix(
  ...,
  y,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.Train"),
  cutoff = MachineShop::settings("cutoff")
)

SelectedModelFrame(
  ...,
  control = MachineShop::settings("control"),
  metrics = NULL,
  stat = MachineShop::settings("stat.Train"),
  cutoff = MachineShop::settings("cutoff")
)
}
\arguments{
\item{...}{\code{\link{formula}}, design \code{\link{matrix}} of predictors,
or \code{\link{ModelFrame}} objects, or a list of one of these types.}

\item{data}{\link[=data.frame]{data frame} or an object that can be converted
to one.}

\item{control}{\link[=controls]{control} function, function name, or call
defining the resampling method to be employed.}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.  If not specified, default
metrics defined in the \link{performance} functions are used.  Recipe
selection is based on the first calculated metric.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metric values for recipe selection.}

\item{cutoff}{argument passed to the \code{metrics} functions.}

\item{y}{response variable.}
}
\value{
\code{SelectedModelFrame} class object that inherits from
\code{ModelFrame}.
}
\description{
Formula, design matrix, or model frame selection from a candidate set.
}
\examples{
sel_fo <- SelectedFormula(
  sale_amount ~ sale_year + built + style + construction,
  sale_amount ~ sale_year + base_size + bedrooms + basement,
  data = ICHomes
)

model_fit <- fit(sel_fo, model = GLMModel)
(selected_model <- as.MLModel(model_fit))
plot(selected_model)

}
\seealso{
\code{\link{fit}}, \code{\link{resample}}
}
