% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLControl.R
\name{set_strata}
\alias{set_strata}
\title{Resampling Stratification Control}
\usage{
set_strata(x, breaks = 4, nunique = 5, prop = 0.1, size = 20)
}
\arguments{
\item{x}{\link[=controls]{control} object.}

\item{breaks}{number of quantile bins desired for stratification of numeric
data during resampling.}

\item{nunique}{number of unique values at or below which numeric data are
stratified as categorical.}

\item{prop}{minimum proportion of data in each strata.}

\item{size}{minimum number of values in each strata.}
}
\value{
Argument \code{x} updated with the supplied parameters.
}
\description{
Set parameters that control the construction of strata during resample
estimation of model performance.
}
\details{
The arguments control resampling strata which are constructed from numeric
proportions for \code{\link{BinomialVariate}}; original values for
\code{character}, \code{factor}, \code{logical}, \code{numeric}, and
\code{ordered}; first columns of values for \code{matrix}; and numeric times
within event statuses for \code{Surv}.  Stratification of survival data by
event status only can be achieved by setting \code{breaks = 1}.  Numeric
values are stratified into quantile bins and categorical values into factor
levels.  The number of bins will be the largest integer less than or equal to
\code{breaks} satisfying the \code{prop} and \code{size} control argument
thresholds.  Categorical levels below the thresholds will be pooled
iteratively by reassigning values in the smallest nominal level to the
remaining ones at random and by combining the smallest adjacent ordinal
levels.  Missing values are replaced with non-missing values sampled at
random with replacement.
}
\examples{
CVControl() \%>\% set_strata(breaks = 3)

}
\seealso{
\code{\link{set_monitor}}, \code{\link{set_predict}},
\code{\link{resample}}, \code{\link{SelectedInput}},
\code{\link{SelectedModel}}, \code{\link{TunedInput}},
\code{\link{TunedModel}}
}
