% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predict.R
\name{get_predict}
\alias{get_predict}
\title{Creates vectorized predict functions from models.}
\usage{
get_predict(models, separator = "_", ...)
}
\arguments{
\item{models}{list. List with models to create the prediction function. The model objects must have methods for function `predict`.}

\item{separator}{character. Character that separates variable names, years and scenarios.}

\item{...}{additional arguments to be passed to predict function (specific for the method of the models supplied).}
}
\value{
Returns a list of vectorized functions that get predictions for the models inputted. The functions generated do not perform lazy evaluation, the user must be explicit
}
\description{
\code{get_predict} Takes inputed models and create vectorized functions able to get the model predictionsfor any value inputed. Also outputs a table comparing models.
nls
gam
glm
lm
randomForest
gbm
gls
bam
}
\examples{

library(mgcv)

perf_no_size <-
  gamm(performance ~ s(temp, bs = 'cs'),
       random = list(id = ~ 1),
       data = TtorquatusPerformance)

perf_size <-
  gamm(performance ~ s(temp, bs = 'cs') + size,
       random = list(id = ~ 1),
       data = TtorquatusPerformance)

perf_functions <- get_predict(list(perf_s = perf_size,
                                   perf_ns = perf_no_size),
                              type = "response")

perf_nsFUN <- perf_functions$perf_ns
perf_sFUN <- perf_functions$perf_s

perf_nsFUN(temp = 30)
perf_sFUN(temp = 30, size = 70)
perf_nsFUN(temp = 30:35)
perf_sFUN(temp = 30, size = 70:75)
perf_sFUN(temp = 30:35, size = 70:75)

}
