% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rasters.R
\name{get_rasters}
\alias{get_rasters}
\title{Retrieve and organize spatial rasters.}
\usage{
get_rasters(
  var = NULL,
  scenario = NULL,
  raster_path = NULL,
  ext = c(-180, 180, -60, 90),
  coord_col = c("Lon", "Lat"),
  margin = 0,
  separator = "_"
)
}
\arguments{
\item{var}{character. Names of variables to be loaded.}

\item{scenario}{character. Names of scenarios for the variables.}

\item{raster_path}{character. Path to folder with raster files. See \code{\link[raster]{writeFormats}} for supported formats}

\item{ext}{numeric, data. frame or Extent object. Extent to crop rasters.}

\item{coord_col}{character. Names of columns containing Longitude and Latitude.}

\item{margin}{numeric. Additional distance to be added to margin of extent, in degrees.}

\item{separator}{character. Character that separates variable names and scenario names.}
}
\value{
Returns a list of raster stacks for the variables required, organized by year/scenario combination.
}
\description{
\code{get_rasters} Loads rasters from directory and returns them in an organized list of specified scenarios.
}
\examples{
\dontrun{
# replace rasterpath with the directory on your computer containing worldclim data

Fulanus_Ecorasters_present <-
  get_rasters(
    var = c('prec', 'tmin', 'tmax'),
    scenario = 'present',
    raster_path = "C:/Users/gabri/Dropbox/Mapinguari/global_grids_10_minutes",
    ext = FulanusDistribution[c(2,3)],
    margin = 5)
}
}
