% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRvaluerange.R
\name{utilMWRvaluerange}
\alias{utilMWRvaluerange}
\title{Check if incomplete range in \code{Value Range} column}
\usage{
utilMWRvaluerange(accdat)
}
\arguments{
\item{accdat}{\code{data.frame} for data quality objectives file for accuracy as returned by \code{\link{readMWRacc}}}
}
\value{
A named vector of \code{"gap"}, \code{"nogap"}, or \code{"overlap"} indicating if a gap is present, no gap is present, or an overlap is present in the ranges provided by the value range for each parameter.  The names correspond to the parameters.
}
\description{
Check if incomplete range in \code{Value Range} column
}
\details{
The function evaluates if an incomplete or overlapping range is present in the \code{Value Range} column of the data quality objectives file for accuracy
}
\examples{
# accuracy path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', 
     package = 'MassWateR')

# accuracy data with no checks
accdat <- readxl::read_excel(accpth, na = c('NA', ''), col_types = 'text')
accdat <- dplyr::mutate(accdat, dplyr::across(-c(`Value Range`), ~ dplyr::na_if(.x, 'na'))) 

utilMWRvaluerange(accdat)
}
