% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindthem.R
\name{bindthem}
\alias{bindthem}
\title{Binds Imputed Datasets and Dataframes}
\usage{
bindthem(datasets, data)
}
\arguments{
\item{datasets}{This argument specifies an object of the \code{mimids} or \code{wimids} class.}

\item{data}{This argument specifies a dataframe.}
}
\value{
This function returns an object of the \code{mimids} or \code{wimids} class after binding a dataframe to each imputed dataset of the inputted object.
}
\description{
The \code{bindthem()} function binds a dataframe to each imputed dataset of the \code{mimids} or \code{wimids} class objects in a row-wise fashion.
}
\details{
This functions can be used similar to the \code{cbind()} function (from the \pkg{mice} package).
}
\examples{
\donttest{
#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg", "logreg", "logreg", "logreg"))

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                              approach = 'within', method = 'nearest')

#Binding a (sorted) dataframe to imputed datasets of the 'matched.datasets'
#(assume that 'data' is a dataset with information on new variables)
matched.datasets <- bindthem(matched.datasets, data)
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchthem]{matchthem}}

\code{\link[=weightthem]{weightthem}}

\code{\link[=mergethem]{mergethem}}
}
\author{
Farhad Pishgar
}
