% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMI.R
\name{PSI}
\alias{PSI}
\title{Procrustes Similarity Index}
\usage{
PSI(X1, X2)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}
}
\value{
The Procrustes Similarity Index
}
\description{
An index based on the RV coefficient with Procrustes rotation.
}
\examples{
X1  <- scale( matrix( rnorm(100*300), 100,300), scale = FALSE)
usv <- svd(X1)
X2  <- usv$u[,-3] \%*\% diag(usv$d[-3]) \%*\% t(usv$v[,-3])
PSI(X1,X2)

}
\references{
Sibson, R; 1978. "Studies in the Robustness of Multidimensional Scaling: Procrustes Statistics". Journal of the Royal Statistical Society. Series B (Methodological), Vol. 40, No. 2, pp. 234-238.
}

