% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimezone.R
\name{getTimezone}
\alias{getTimezone}
\title{Return Olson timezones at specified locations}
\usage{
getTimezone(lon, lat, dataset = "SimpleTimezones", countryCodes = NULL,
  allData = FALSE, useBuffering = FALSE)
}
\arguments{
\item{lon}{vector of longitudes in decimal degrees}

\item{lat}{vector of latitudes in decimal degrees}

\item{dataset}{name of spatial dataset to use}

\item{countryCodes}{vector of countryCodes}

\item{allData}{logical specifying whether a full dataframe should be returned}

\item{useBuffering}{logical flag specyfing the use of location buffering to 
find the nearest polygon if not target polygon is found}
}
\value{
Vector of Olson timezones.
}
\description{
Uses spatial comparison to determine which timezone polygons the 
locations fall into and returns the Olson timezone strings for those polygons.
    
Specification of \code{countryCodes} limits spatial searching to the 
specified countries and greatly improves performance.
    
If \code{allData=TRUE}, additional data is returned.
}
\examples{
lon <- seq(-120,-60,5)
lat <- seq(20,80,5)
getTimezone(lon,lat)
}
\references{
\url{http://efele.net/maps/tz/}
}
\seealso{
SimpleTimezones

getSpatialData
}
\keyword{locator}
