% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_summarize.R
\name{sts_summarize}
\alias{sts_summarize}
\title{Create summary time series for an \emph{sts} time series object}
\usage{
sts_summarize(
  sts,
  timezone = NULL,
  unit = c("day", "week", "month", "year"),
  FUN = NULL,
  ...,
  minCount = NULL
)
}
\arguments{
\item{sts}{\emph{sts} object.}

\item{timezone}{Olson timezone used to interpret dates.}

\item{unit}{Unit used to summarize by (\emph{e.g.} "day").}

\item{FUN}{Function used to summarize time series.}

\item{...}{Additional arguments to be passed to \code{FUN}
(_e.g._ \code{na.rm = TRUE}).}

\item{minCount}{Minimum number of valid data records required to calculate
summaries. Time periods with fewer valid records will be assigned \code{NA}.}
}
\value{
An \emph{sts} time series object containing daily (or other)
statistical summaries.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Columns of numeric data in \code{sts$data} are grouped by \code{unit} and then
summarized using \code{FUN}.

Columns with non-numeric data are summarized by just picking the first
occurrence in each \code{unit}. This preserves the utility of columns
containing repeated metadata.

The most typical use case is creating daily averages where each day begins at
midnight. Day boundaries are calculated using the specified \code{timezone}
or, if \code{NULL}, the time zone found in \code{sts$meta$timezone[1]}.
Leaving \code{timezone = NULL}, the default, results in "local time" date
filtering which is the most common use case.
}
