% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_select.R
\name{mts_select}
\alias{mts_select}
\title{Reorder and subset time series within an \emph{mts} time series object}
\usage{
mts_select(mts = NULL, deviceDeploymentID = NULL)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{deviceDeploymentID}{Vector of timeseries unique identifiers.}
}
\value{
A reordered (subset) of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
This function acts similarly to \code{dplyr::select()} working on
\code{mts$data}. The returned \emph{mts} object will contain only those
time series identified by \code{deviceDeploymentID} in the order specified.

This can be used the specify a preferred order and is helpful when using
faceted plot functions based on \pkg{ggplot}
such as those found in the \pkg{AirMonitorPlots} package.
}
\examples{
library(MazamaTimeSeries)

# Filter for "El Monte"
El_Monte <-
  example_mts \%>\%
  mts_filterMeta(communityRegion == "El Monte")

ids <- El_Monte$meta$deviceDeploymentID
rev_ids <- rev(ids)

print(ids)
print(rev_ids)

rev_El_Monte <-
  example_mts \%>\%
  mts_select(rev_ids)

print(rev_El_Monte$meta$deviceDeploymentID)

}
\seealso{
\link{mts_filterData}

\link{mts_filterDate}

\link{mts_filterDatetime}
}
