\name{ADTreatSelExample3}
\alias{ADTreatSelExample3}
\title{
Simulation-based design of an adaptive trial with treatment selection (time-to-event endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a time-to-event primary efficacy endpoint. Two regimens of an experimental treatment will be evaluated in this trial compared to a control. An adaptive design with two interim analyses will be employed in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial). The following decision rules will be applied at the interim looks:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). A treatment arm may be dropped due to futility if the treatment-specific conditional power is too low. The trial will be terminated for futility if all treatment arms are dropped.
    \item Treatment selection rule will be applied at the second interim analysis (IA2). The best performing treatment will be selected for the final analysis (FA) and the other treatment will be dropped at this interim analysis.
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 180 enrolled patients per arm will be used in the trial. 
    \item The target number of events at FA is set to 450.
    \item The annual patient dropout rate is equal to 5\% (the time to patient dropout is assumed to follow an exponential distribution).
    \item The length of the patient enrollment period is 24 months and the median enrollment time is expected to be 18 months.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim analyses will be performed after 40\% and 60\% of the original number of events have been accrued. 
}
The futility threshold for each treatment arm at IA1 is set to 10\%. The median event times are assumed to be 7.5 months in the control arms and 10.5 months in both treatment arms, respectively. Under the assumption of exponentially distributed event times, these assumptions correspond to a hazard ratio of 0.71 in each treatment arm.

Key operating characteristics of this adaptive design with a treatment selection option at the second interim look will be evaluated using the \code{\link{ADTreatSel}} function based on 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report for this adaptive design can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADTreatSelApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADTreatSel}}, \code{\link{ADTreatSelExample1}}, \code{\link{ADTreatSelExample2}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Time-to-event"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, two treatments)
parameters$sample_size = c(180, 180, 180)

# Annual patient dropout rate
parameters$dropout_rate = 0.05

# Median time in the control arm 
parameters$control_time = 7.5

# Median times in the treatment arms
parameters$treatment_time = c(10.5, 10.5)

# Target event count at FA
parameters$event_count = 450

# Information fractions at IA1, IA2, FA
parameters$info_frac = c(0.4, 0.6, 1)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.1

# Enrollment period
parameters$enrollment_period = 24

# Median enrollment time
parameters$enrollment_parameter = 18

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations, you should prefer more
parameters$nsims = 100

# Run simulations to compute operating characteristics
results = ADTreatSel(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADTreatSel Time-to-event endpoint.docx", fileext=".docx"))
}