\name{ADPopSelExample3}
\alias{ADPopSelExample3}
\title{
Simulation-based design of an adaptive trial with population selection (time-to-event endpoint)
}
\description{
Consider a seamless Phase II/Phase III or Phase III trial with a binary primary efficacy endpoint. The efficacy and safety profiles of a single dose or regimen of an experimental treatment will be evaluated versus a control in two patient populations (overall population and biomarker-positive population). An adaptive design with two interim analyses will be used in the trial (the first interim analysis may correspond to the end of the Phase II portion of the trial) to support the following decision rules:
\itemize{
	\item Futility stopping rule will be applied at the first interim analysis (IA1). The trial will be terminated for futility if the predicted probability of success (conditional power) in the overall population is too low
    \item Population selection rule will be applied at the second interim analysis (IA2). The most promising population or populations will be selected for the final analysis (FA).
} 
The following design parameters will be assumed:
\itemize{
    \item A balanced design with 230 enrolled patients per arm will be utilized in this trial.
    \item The prevalence of biomarker-positive patients in the overall population is expected to be 40\%.    
    \item The target number of events in the overall population at FA is set to 300. In addition, the target number of events needs to be defined in the biomarker-positive population in case this population is chosen for the final assessment, this value is equal to 150.
    \item The annual patient dropout rate is equal to 5\% (the time to patient dropout is assumed to follow an exponential distribution).
    \item The length of the patient enrollment period is 12 months and the median enrollment time is expected to be 8 months.
    \item The information fractions at IA1 and IA2 are set to 40\% and 60\%, i.e., the first and second interim looks will be taken after 40\% and 60\% of the patients complete the treatment period or drop out of the trial before completing the treatment period. 
}
In addition, the following decision rules will be considered at the two interim analyses:
\itemize{
    \item The futility threshold at IA1 is set to 10\%.
    \item The influence and interaction thresholds used in the population selection rule are set to 0.1 and 1.3. The conditions based on these thresholds are applied sequentially to determine if the final analysis should be performed in the overall population only, in the biomarker-positive population only or simultaneously in both populations. 
}
The treatment effect assumptions are specified within the biomarker-positive and biomarker-negative populations. A common effect will be assumed in the control arm, i.e., the median time of 7.5 months regardless of the biomarker status. The median time of 9.5 months in the treated patients with a biomarker-negative status indicates a weaker treatment effect (hazard ratio of 0.79) whereas the median time of 11 months in the treated patients with a biomarker-positive status corresponds to a much stronger treatment effect (hazard ratio of 0.68). 

Key operating characteristics of the proposed adaptive design with population selection will be evaluated using the \code{\link{ADPopSel}} function based on 10,000 simulation runs. To invoke this function, a list of all design and decision rule parameters (\code{parameters}) needs to be created as shown below. A comprehensive simulation report for this adaptive design can be generated by calling the \code{\link{GenerateReport}} function and a graphical user interface can be launched using the \code{\link{ADPopSelApp}} function.
}
\arguments{No arguments}
\value{No return value}
\seealso{
  \code{\link{ADPopSel}}, \code{\link{ADPopSelExample1}}, \code{\link{ADPopSelExample2}}
}
\examples{
# List of all parameters
parameters = list()

# Endpoint type
parameters$endpoint_type = "Time-to-event"

# Direction of favorable outcome
parameters$direction = "Higher"

# Number of enrolled patients (control, treatment) 
parameters$sample_size = c(230, 230)

# Prevalence of biomarker-positive patients in the overall population
parameters$prevalence = 0.4

# Annual patient dropout rate
parameters$dropout_rate = 0.05

# Median times in the control arm (biomarker-negative, biomarker-positive)
parameters$control_time = c(7.5, 7.5)

# Median times in the treatment arm (biomarker-negative, biomarker-positive)
parameters$treatment_time = c(9.5, 11)

# Information fractions at IA1, IA2, FA
parameters$info_frac = c(0.4, 0.6, 1)

# Target event count at FA (overall, biomarker-positive)
parameters$event_count = c(300, 150)

# Futility threshold for conditional power at IA1
parameters$futility_threshold = 0.1

# Influence threshold at IA2
parameters$influence = 0.1

# Interaction threshold at IA2
parameters$interaction = 1.3

# Enrollment period
parameters$enrollment_period = 12

# Median enrollment time
parameters$enrollment_parameter = 8

# One-sided alpha level
parameters$alpha = 0.025

# Number of simulations, you should prefer more
parameters$nsims = 100

# Run simulations to compute operating characteristics
results = ADPopSel(parameters)

# Generate a simulation report (remove tempfile)
GenerateReport(results, 
              tempfile("ADPopSel Time-to-event endpoint.docx", fileext=".docx"))
}