% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectedComponents.R
\name{connectedComponents}
\alias{connectedComponents}
\title{Connected components of a 3D mesh}
\usage{
connectedComponents(
  vertices,
  faces,
  mesh = NULL,
  triangulate = FALSE,
  clean = FALSE,
  normals = FALSE,
  numbersType = "double"
)
}
\arguments{
\item{vertices}{a numeric matrix with three columns, or a \code{bigq}
matrix with three columns if \code{numbersType="gmp"}}

\item{faces}{either an integer matrix (each row provides the vertex indices
of the corresponding face) or a list of integer vectors, each one
providing the vertex indices of the corresponding face}

\item{mesh}{if not \code{NULL}, this argument takes precedence over
\code{vertices} and \code{faces}, and must be either a list containing
the fields \code{vertices} and \code{faces} (objects as described above),
otherwise a \strong{rgl} mesh (i.e. a \code{mesh3d} object)}

\item{triangulate}{Boolean, whether to triangulate the faces}

\item{clean}{Boolean, whether to clean the mesh (merging duplicated
vertices, duplicated faces, removed isolated vertices)}

\item{normals}{Boolean, whether to compute the normals}

\item{numbersType}{the type of the numbers used in C++ for the
computations; must be one of \code{"double"}, \code{"lazyExact"}
(a type provided by CGAL for exact computations), or \code{"gmp"}
(exact computations with rational numbers); using exact computations can
improve the detection of the exterior edges}
}
\value{
A list of meshes, the connected components, each one being
  represented as the output of the \code{\link{Mesh}} function.
}
\description{
Computes the connected components of a 3D mesh; for each
  returned component, its faces are coherently oriented, its normals are
  computed if desired, and it is triangulated if desired.
}
\examples{
library(MeshesOperations)
library(rgl)

# a tetrahedron with ill-oriented faces ####
vertices1 <- rbind(
  c(-1, -1, -1),
  c( 1,  1, -1),
  c( 1, -1,  1),
  c(-1,  1,  1)
)
faces1 <- rbind(
  c(1, 2, 3),
  c(3, 4, 2),
  c(4, 2, 1),
  c(4, 3, 1)
)
# same tetrahedron translated ####
vertices2 <- vertices1 + 3
# merge the two tetrahedra ####
vertices <- rbind(vertices1, vertices2)
faces <- rbind(faces1, faces1 + 4)

# now run the `connectedComponents` function ####
meshes <- connectedComponents(vertices, faces, normals = FALSE)
mesh1 <- meshes[[1]]; mesh2 <- meshes[[2]]
# plot
tmesh1 <- toRGL(mesh1)
tmesh2 <- toRGL(mesh2)
open3d(windowRect = c(50, 50, 562, 562))
shade3d(tmesh1, color = "green", back = "culled")
shade3d(tmesh2, color = "red", back = "culled")
}
