% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRegion_SIM.R
\name{singleStructureGenerator}
\alias{singleStructureGenerator}
\title{singleStructureGenerator}
\description{
an R6 class representing a single genomic structure
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-singleStructureGenerator-init_neighbSt}{\code{singleStructureGenerator$init_neighbSt()}}
\item \href{#method-singleStructureGenerator-initialize_ratetree}{\code{singleStructureGenerator$initialize_ratetree()}}
\item \href{#method-singleStructureGenerator-new}{\code{singleStructureGenerator$new()}}
\item \href{#method-singleStructureGenerator-get_seq}{\code{singleStructureGenerator$get_seq()}}
\item \href{#method-singleStructureGenerator-get_seqFirstPos}{\code{singleStructureGenerator$get_seqFirstPos()}}
\item \href{#method-singleStructureGenerator-get_seq2ndPos}{\code{singleStructureGenerator$get_seq2ndPos()}}
\item \href{#method-singleStructureGenerator-get_seqLastPos}{\code{singleStructureGenerator$get_seqLastPos()}}
\item \href{#method-singleStructureGenerator-get_seq2ndButLastPos}{\code{singleStructureGenerator$get_seq2ndButLastPos()}}
\item \href{#method-singleStructureGenerator-get_combiStructure_index}{\code{singleStructureGenerator$get_combiStructure_index()}}
\item \href{#method-singleStructureGenerator-update_interStr_firstNeighbSt}{\code{singleStructureGenerator$update_interStr_firstNeighbSt()}}
\item \href{#method-singleStructureGenerator-update_interStr_lastNeighbSt}{\code{singleStructureGenerator$update_interStr_lastNeighbSt()}}
\item \href{#method-singleStructureGenerator-get_eqFreqs}{\code{singleStructureGenerator$get_eqFreqs()}}
\item \href{#method-singleStructureGenerator-SSE_evol}{\code{singleStructureGenerator$SSE_evol()}}
\item \href{#method-singleStructureGenerator-IWE_evol}{\code{singleStructureGenerator$IWE_evol()}}
\item \href{#method-singleStructureGenerator-get_alpha_pI}{\code{singleStructureGenerator$get_alpha_pI()}}
\item \href{#method-singleStructureGenerator-get_beta_pI}{\code{singleStructureGenerator$get_beta_pI()}}
\item \href{#method-singleStructureGenerator-get_alpha_mI}{\code{singleStructureGenerator$get_alpha_mI()}}
\item \href{#method-singleStructureGenerator-get_beta_mI}{\code{singleStructureGenerator$get_beta_mI()}}
\item \href{#method-singleStructureGenerator-get_alpha_pNI}{\code{singleStructureGenerator$get_alpha_pNI()}}
\item \href{#method-singleStructureGenerator-get_beta_pNI}{\code{singleStructureGenerator$get_beta_pNI()}}
\item \href{#method-singleStructureGenerator-get_alpha_mNI}{\code{singleStructureGenerator$get_alpha_mNI()}}
\item \href{#method-singleStructureGenerator-get_beta_mNI}{\code{singleStructureGenerator$get_beta_mNI()}}
\item \href{#method-singleStructureGenerator-get_alpha_Ri}{\code{singleStructureGenerator$get_alpha_Ri()}}
\item \href{#method-singleStructureGenerator-get_iota}{\code{singleStructureGenerator$get_iota()}}
\item \href{#method-singleStructureGenerator-get_Ri_values}{\code{singleStructureGenerator$get_Ri_values()}}
\item \href{#method-singleStructureGenerator-clone}{\code{singleStructureGenerator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-init_neighbSt"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-init_neighbSt}{}}}
\subsection{Method \code{init_neighbSt()}}{
Public method: Initialization of $neighbSt

This fuction initiates each CpG position $neighbSt as encoded in $mapNeighbSt_matrix
Positions at the edge of the entire simulated sequence use
their only neighbor as both neighbors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$init_neighbSt()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-initialize_ratetree"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-initialize_ratetree}{}}}
\subsection{Method \code{initialize_ratetree()}}{
Public method: Initialization of $ratetree

This function initializes $ratetree
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$initialize_ratetree()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-new}{}}}
\subsection{Method \code{new()}}{
Create a new singleStructureGenerator object.

Note that this object is typically generated withing a combiStructureGenerator object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$new(
  globalState,
  n,
  eqFreqs = NULL,
  combiStr = NULL,
  combiStr_index = NULL,
  params = NULL,
  testing = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{globalState}}{Character. Structure's favored global state: "M" for methylated (island structures) / "U" for unmethylated (non-island structures).}

\item{\code{n}}{Numerical Value. Number of CpG positions}

\item{\code{eqFreqs}}{Default NULL. When given: numerical vector with structure's methylation state equilibrium frequencies (for unmethylated, partially methylated and methylated)}

\item{\code{combiStr}}{Default NULL. When initiated from combiStructureGenerator: object of class combiStructureGenerator containing it}

\item{\code{combiStr_index}}{Default NULL. When initiated from combiStructureGenerator: index in Object of class combiStructureGenerator}

\item{\code{params}}{Default NULL. When given: data frame containing model parameters}

\item{\code{testing}}{Default FALSE. TRUE for testing output}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{singleStructureGenerator} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_seq"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_seq}{}}}
\subsection{Method \code{get_seq()}}{
Public method: Get object's methylation state sequence

Encoded with 1 for unmethylated, 2 for partially methylated and 3 for methylated
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_seq()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
vector with equilibrium frequencies of unmethylated, partially methylated and methylated
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_seqFirstPos"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_seqFirstPos}{}}}
\subsection{Method \code{get_seqFirstPos()}}{
Public method: Get first sequence position methylation state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_seqFirstPos()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numerical encoding of first position's methylation state
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_seq2ndPos"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_seq2ndPos}{}}}
\subsection{Method \code{get_seq2ndPos()}}{
Public method: Get second sequence position methylation state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_seq2ndPos()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numerical encoding of second position's methylation state. NULL if position does not exist
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_seqLastPos"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_seqLastPos}{}}}
\subsection{Method \code{get_seqLastPos()}}{
Public method: Get first sequence position methylation state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_seqLastPos()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numerical encoding of first position's methylation state
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_seq2ndButLastPos"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_seq2ndButLastPos}{}}}
\subsection{Method \code{get_seq2ndButLastPos()}}{
Public method: Get second but last sequence position methylation state
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_seq2ndButLastPos()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
numerical encoding of second but last position's methylation state. NULL if position does not exist
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_combiStructure_index"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_combiStructure_index}{}}}
\subsection{Method \code{get_combiStructure_index()}}{
Public method: Get index in object of class combiStructureGenerator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_combiStructure_index()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
index in object of class combiStructureGenerator
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-update_interStr_firstNeighbSt"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-update_interStr_firstNeighbSt}{}}}
\subsection{Method \code{update_interStr_firstNeighbSt()}}{
Public method: Update neighbSt of next singleStructureGenerator object within combiStructureGenerator object

This function is used when the last $seq position of a singleStructureGenerator object
changes methylation state to update the neighbSt position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$update_interStr_firstNeighbSt(
  leftNeighbSt,
  rightNeighbSt
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leftNeighbSt}}{$seq state of left neighbor (left neighbor is in previous singleStructureGenerator object)}

\item{\code{rightNeighbSt}}{$seq state of right neighbor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-update_interStr_lastNeighbSt"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-update_interStr_lastNeighbSt}{}}}
\subsection{Method \code{update_interStr_lastNeighbSt()}}{
Public method: Update neighbSt of previous singleStructureGenerator object within combiStructureGenerator object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$update_interStr_lastNeighbSt(
  leftNeighbSt,
  rightNeighbSt
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{leftNeighbSt}}{$seq state of right neighbor (left neighbor is in next singleStructureGenerator object)}

\item{\code{rightNeighbSt}}{$seq state of right neighbor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_eqFreqs"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_eqFreqs}{}}}
\subsection{Method \code{get_eqFreqs()}}{
Public method: Get object's equilibrium Frequencies
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_eqFreqs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
vector with equilibrium frequencies of unmethylated, partially methylated and methylated
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-SSE_evol"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-SSE_evol}{}}}
\subsection{Method \code{SSE_evol()}}{
Public method. Simulate how CpG dinucleotide methylation state changes due to the SSE process
along a time step of length dt
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$SSE_evol(dt, testing = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dt}}{time step length.}

\item{\code{testing}}{logical value for testing purposes. Default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
default NULL. If testing TRUE it returns a list with the number of events sampled and a
dataframe with the position(s) affected, new state and old methylation state.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-IWE_evol"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-IWE_evol}{}}}
\subsection{Method \code{IWE_evol()}}{
Public Method. Simulate IWE Events

Simulates how CpG Islands' methylation state frequencies change and simultaneous sites change methylation state
along a branch of length t according to the SSE-IWE model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$IWE_evol(testing = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{testing}}{logical value for testing purposes. Default FALSE.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The function checks if the methylation equilibrium frequencies (\code{eqFreqs}) and sequence observed
frequencies (\code{obsFreqs}) change after the IWE event. If there is a change in either
frequencies, the corresponding change flags(\code{eqFreqsChange}
in the \code{infoIWE} list will be set to \code{TRUE}.
}

\subsection{Returns}{
If testing = TRUE it returns a list.
If there was a change in the equilibrium frequencies the list contains the following 7 elements, if not it contains the first 3 elements:
\describe{
\item{\code{eqFreqsChange}}{logical indicating if there was a change in the equilibrium frequencies.}
\item{\code{old_eqFreqs}}{Original equilibrium frequencies before the IWE event.}
\item{\code{new_eqFreqs}}{New equilibrium frequencies after the IWE event.}
\item{\code{old_obsFreqs}}{Original observed frequencies before the IWE event.}
\item{\code{new_obsFreqs}}{New observed frequencies after the IWE event.}
\item{\code{IWE_case}}{Description of the IWE event case.}
\item{\code{Mk}}{Transition matrix used for the IWE event.}
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_alpha_pI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_alpha_pI}{}}}
\subsection{Method \code{get_alpha_pI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_alpha_pI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter alpha_pI for sampling island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_beta_pI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_beta_pI}{}}}
\subsection{Method \code{get_beta_pI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_beta_pI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_alpha_mI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_alpha_mI}{}}}
\subsection{Method \code{get_alpha_mI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_alpha_mI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_beta_mI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_beta_mI}{}}}
\subsection{Method \code{get_beta_mI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_beta_mI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_alpha_pNI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_alpha_pNI}{}}}
\subsection{Method \code{get_alpha_pNI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_alpha_pNI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling non-island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_beta_pNI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_beta_pNI}{}}}
\subsection{Method \code{get_beta_pNI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_beta_pNI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling non-island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_alpha_mNI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_alpha_mNI}{}}}
\subsection{Method \code{get_alpha_mNI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_alpha_mNI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling non-island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_beta_mNI"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_beta_mNI}{}}}
\subsection{Method \code{get_beta_mNI()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_beta_mNI()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for sampling non-island equilibrium frequencies
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_alpha_Ri"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_alpha_Ri}{}}}
\subsection{Method \code{get_alpha_Ri()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_alpha_Ri()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for gamma distribution shape to initialize the 3 $Ri_values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_iota"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_iota}{}}}
\subsection{Method \code{get_iota()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_iota()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Model parameter for gamma distribution expected value to initialize the 3 $Ri_values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-get_Ri_values"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-get_Ri_values}{}}}
\subsection{Method \code{get_Ri_values()}}{
Public Method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$get_Ri_values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The 3 $Ri_values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-singleStructureGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-singleStructureGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{singleStructureGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
