% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pct_agreement1.R
\name{pct_agreement1}
\alias{pct_agreement1}
\title{Plot the percentage agreement after recalibration}
\usage{
pct_agreement1(object)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}
}
\description{
This function draws the "percentage agreement plot" after recalibration,
which shows the amount of percentage agreement.
It is obtained by graphing the percentage agreement index after recalibration
versus the BLUP of the latent trait, \code{x}, along with its 95\% simultaneous
confidence bands.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the percentage agreement after recalibration
pct_agreement0(measure_model)}
}
