% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviance_gamma.R
\name{deviance_gamma}
\alias{deviance_gamma}
\title{Gamma Deviance}
\usage{
deviance_gamma(actual, predicted, w = NULL, ...)
}
\arguments{
\item{actual}{Strictly positive observed values.}

\item{predicted}{Strictly positive predicted values.}

\item{w}{Optional case weights.}

\item{...}{Further arguments passed to \code{weighted_mean}.}
}
\value{
A numeric vector of length one.
}
\description{
Weighted average of (unscaled) unit Gamma deviance, see e.g. [1]. Special case of Tweedie deviance with Tweedie parameter 2. The smaller the deviance, the better.
}
\examples{
deviance_gamma(1:10, c(1:9, 12))
deviance_gamma(1:10, c(1:9, 12), w = rep(1, 10))
deviance_tweedie(1:10, c(1:9, 12), tweedie_p = 2)
deviance_tweedie(1:10, c(1:9, 12), tweedie_p = 1.99)
deviance_gamma(1:10, c(1:9, 12), w = 1:10)
}
\references{
[1] Jorgensen, B. (1997). The Theory of Dispersion Models. Chapman & Hall/CRC. ISBN 978-0412997112.
}
\seealso{
\code{\link{deviance_tweedie}}.
}
