% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{weighted_median}
\alias{weighted_median}
\title{Weighted Median}
\usage{
weighted_median(x, w = NULL, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{w}{Optional vector of non-negative case weights.}

\item{...}{Further arguments passed to \code{\link[=weighted_quantile]{weighted_quantile()}}.}
}
\value{
A length-one numeric vector.
}
\description{
Calculates weighted median based on \code{\link[=weighted_quantile]{weighted_quantile()}}.
}
\examples{
n <- 21
x <- seq_len(n)
quantile(x, probs = 0.5)
weighted_median(x, w = rep(1, n))
weighted_median(x, w = x)
quantile(rep(x, x), probs = 0.5)
}
\seealso{
\code{\link[=weighted_quantile]{weighted_quantile()}}
}
