% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMiRKAT.R
\name{MMiRKAT}
\alias{MMiRKAT}
\title{Multivariate Microbiome Regression-based Kernel Association Test}
\usage{
MMiRKAT(Y, X = NULL, Ks, returnKRV = FALSE, returnR2 = FALSE)
}
\arguments{
\item{Y}{A numerical n by p matrix of p continuous outcome variables, n being sample size.}

\item{X}{A numerical n by q matrix or data frame, containing q additional covariates that you want to adjust for (Default = NULL).
If it is NULL, an intercept only model is fit.}

\item{Ks}{A list of numerical n by n kernel matrices, or a single n by n kernel matrix, where n is the sample size. Kernels can be 
constructed from distance matrices (such as Bray-Curtis or UniFrac distances) using the function D2K, or through other mathematical approaches.}

\item{returnKRV}{A logical indicating whether to return the KRV statistic. Defaults to FALSE.}

\item{returnR2}{A logical indicating whether to return the R-squared coefficient. Defaults to FALSE.}
}
\value{
Returns a list of the MMiRKAT p-values for each inputted kernel matrix, labeled with the names of the kernels, if given.
    \item{p_values}{list of the p-values for each individual kernel matrix inputted}
    \item{KRV}{A vector of kernel RV statistics (a measure of effect size), one for each candidate kernel matrix. Only returned if returnKRV = TRUE}
    \item{R2}{A vector of R-squared statistics, one for each candidate kernel matrix. Only returned if returnR2 = TRUE}
}
\description{
Test for association between overall microbiome composition and multiple continuous outcomes.
}
\details{
Missing data is not permitted. Please remove all individuals with missing Y, X, K prior to analysis

The method of generating kernel specific p-values is "davies", which represents an exact method that computes the p-value by
inverting the characteristic function of the mixture chisq.
}
\examples{
 
library(GUniFrac)
data(throat.tree)
data(throat.otu.tab)
data(throat.meta)

unifracs <- GUniFrac(throat.otu.tab, throat.tree, alpha=c(0, 0.5, 1))$unifracs

Ds = list(w = unifracs[,,"d_1"], u = unifracs[,,"d_UW"], 
         BC= as.matrix(vegdist(throat.otu.tab , method="bray"))) 
Ks = lapply(Ds, FUN = function(d) D2K(d)) 

n = nrow(throat.otu.tab)
Y = matrix(rnorm(n*3, 0, 1), n, 3)

covar = cbind(as.numeric(throat.meta$Sex == "Male"), as.numeric(throat.meta$PackYears))
MMiRKAT(Y = Y, X = covar, Ks = Ks) 

}
\references{
Zheng, H., Zhan, X., Tong, X., Zhao, N., Maity,A., Wu, M.C., and Chen,J. A small-sample multivariate kernel machine test for 
microbiome association studies. Genetic Epidemiology, 41(3), 210-220. DOI: 10.1002/gepi.22030
}
\author{
Nehemiah Wilson, Haotian Zheng, Xiang Zhan, Ni Zhao
}
