% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mosquito_RM.R
\name{get_config_mosquito_RM}
\alias{get_config_mosquito_RM}
\title{Get parameters for generalized Ross-Macdonald mosquito model}
\usage{
get_config_mosquito_RM(path)
}
\arguments{
\item{path}{a file path to a JSON file}
}
\value{
a named \link{list}
}
\description{
The JSON config file should have 8 entries:
\itemize{
\item stochastic: a boolean value
\item f: scalar
\item q: scalar
\item eip: scalar or vector; see \link{time_varying_parameter} for valid formats
\item p: scalar or vector; see \link{time_varying_parameter} for valid formats
\item psi: matrix
\item nu: scalar
\item M: vector
\item Y: vector
\item Z: vector
}

For interpretation of the entries, please read \link{setup_mosquito_RM}.
}
\examples{
# to see an example of proper JSON input, run the following
library(jsonlite)
t <- 10 # days to simulate
p <- 5 # number of patches
EIP <-  rep(5, t)
p_surv <- 0.95
psi <- matrix(rexp(p^2), nrow = p, ncol = p)
psi <- psi / rowSums(psi)
par <- list(
 "stochastic" = FALSE,
 "f" = 0.3,
 "q" = 0.9,
 "eip" = EIP,
 "p" = p_surv,
 "psi" = psi,
 "nu" = 20,
 "M" = rep(100, p),
 "Y" = rep(20, p),
 "Z" = rep(5, p)
)
toJSON(par, pretty = TRUE)
}
