% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{get_personal_onedrive}
\alias{get_personal_onedrive}
\alias{get_business_onedrive}
\alias{get_sharepoint_site}
\alias{list_sharepoint_sites}
\alias{get_team}
\alias{list_teams}
\title{Login clients for Microsoft 365}
\usage{
get_personal_onedrive(
  app = .microsoft365r_app_id,
  scopes = c("Files.ReadWrite.All", "User.Read"),
  ...
)

get_business_onedrive(
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)

get_sharepoint_site(
  site_name = NULL,
  site_url = NULL,
  site_id = NULL,
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)

list_sharepoint_sites(
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)

get_team(
  team_name = NULL,
  team_id = NULL,
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)

list_teams(
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)
}
\arguments{
\item{app}{A custom app registration ID to use for authentication. See below.}

\item{scopes}{The Microsoft Graph scopes (permissions) to obtain. It should never be necessary to change these.}

\item{...}{Optional arguments that will ultimately be passed to \code{\link[AzureAuth:get_azure_token]{AzureAuth::get_azure_token}}.}

\item{tenant}{For \code{get_business_onedrive}, \code{get_sharepoint_site} and \code{get_team}, the name of your Azure Active Directory (AAD) tenant. If not supplied, use the value of the \code{CLIMICROSOFT365_TENANT} environment variable, or "common" if that is unset.}

\item{site_name, site_url, site_id}{For \code{get_sharepoint_site}, either the name, web URL or ID of the SharePoint site to retrieve. Supply exactly one of these.}

\item{team_name, team_id}{For \code{get_team}, either the name or ID of the team to retrieve. Supply exactly one of these.}
}
\value{
For \code{get_personal_onedrive} and \code{get_business_onedrive}, an R6 object of class \code{ms_drive}.

For \code{get_sharepoint_site}, an R6 object of class \code{ms_site}; for \code{list_sharepoint_sites}, a list of such objects.

For \code{get_team}, an R6 object of class \code{ms_team}; for \code{list_teams}, a list of such objects.
}
\description{
Microsoft365R provides functions for logging into each Microsoft 365 service.
}
\details{
These functions provide easy access to the various collaboration services that are part of Microsoft 365. On first use, they will call your web browser to authenticate with Azure Active Directory, in a similar manner to other web apps. You will get a dialog box asking for permission to access your information. You only have to authenticate once; your credentials will be saved and reloaded in subsequent sessions.

When authenticating, you can pass optional arguments in \code{...} which will ultimately be received by \code{AzureAuth::get_azure_token}. In particular, if your machine doesn't have a web browser available to authenticate with (for example if you are in a remote RStudio Server session), pass \code{auth_type="device_code"} which is intended for such scenarios.
}
\section{Authenticating to Microsoft 365 Business services}{

Authenticating to Microsoft 365 Business services (Teams, SharePoint and OneDrive for Business) has some specific complexities.

The default "common" tenant for \code{get_team}, \code{get_business_onedrive} and \code{get_sharepoint_site} attempts to detect your actual tenant from your saved credentials in your browser. This may not always succeed, for example if you have a personal account that is also a guest account in a tenant. In this case, supply the actual tenant name, either in the \code{tenant} argument or in the \code{CLIMICROSOFT365_TENANT} environment variable. The latter allows sharing authentication details with the \href{https://pnp.github.io/cli-microsoft365/}{CLI for Microsoft 365}.

The default when authenticating to these services is for Microsoft365R to use its own internal app ID. As an alternative, you (or your admin) can create your own app registration in Azure: it should have a native redirect URI of \verb{http://localhost:1410}, and the "public client" option should be enabled if you want to use the device code authentication flow. You can supply your app ID either via the \code{app} argument, or in the environment variable \code{CLIMICROSOFT365_AADAPPID}.
}

\examples{
\dontrun{

get_personal_onedrive()

# authenticating without a browser
get_personal_onedrive(auth_type="device_code")

odb <- get_business_onedrive("mycompany")
odb$list_items()

mysite <- get_sharepoint_site("My site", tenant="mycompany")
mysite <- get_sharepoint_site(site_url="https://mycompany.sharepoint.com/sites/my-site-url")
mysite$get_drive()$list_items()

myteam <- get_team("My team", tenant="mycompany")
myteam$list_channels()
myteam$get_drive()$list_items()

# you can also use your own app registration ID:
get_business_onedrive(app="app_id")
get_sharepoint_site("My site", app="app_id")

# using the app ID for the CLI for Microsoft 365: set a global option
options(microsoft365r_use_cli_app_id=TRUE)
get_business_onedrive()
get_sharepoint_site("My site")
get_team("My team")

}
}
\seealso{
\code{\link{ms_drive}}, \code{\link{ms_site}}, \code{\link{ms_team}}

\code{\link{add_methods}} for the associated methods that this package adds to the base AzureGraph classes.

The "Authentication" vignette has more details on the authentication process, including troubleshooting and fixes for common problems.

\href{https://pnp.github.io/cli-microsoft365/}{CLI for Microsoft 365} -- a commandline tool for managing Microsoft 365
}
