% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{multitax_bar_pq}
\alias{multitax_bar_pq}
\title{Plot taxonomic distribution across 3 taxonomic levels and optionally
one sample factor}
\usage{
multitax_bar_pq(
  physeq,
  lvl1,
  lvl2,
  lvl3,
  fact = NULL,
  nb_seq = TRUE,
  log10trans = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{lvl1}{(required) Name of the first (higher) taxonomic rank of interest}

\item{lvl2}{(required) Name of the second (middle) taxonomic rank of interest}

\item{lvl3}{(required) Name of the first (lower) taxonomic rank of interest}

\item{fact}{Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}. If not set, the taxonomic
distribution is plot for all samples together.}

\item{nb_seq}{(logical; default TRUE) If set to FALSE, only the number of ASV
is count. Concretely, physeq otu_table is transformed in a binary
otu_table (each value different from zero is set to one)}

\item{log10trans}{(logical, default TRUE) If TRUE,
the number of sequences (or ASV if nb_seq = FALSE) is log10
transformed.}
}
\value{
A ggplot2 graphic
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Note that lvl3 need to be nested in lvl2 which need to be nested
in lvl1
}
\examples{
\donttest{
if (requireNamespace("ggh4x")) {
  multitax_bar_pq(data_fungi_sp_known, "Phylum", "Class", "Order", "Time")
  multitax_bar_pq(data_fungi_sp_known, "Phylum", "Class", "Order")
  multitax_bar_pq(data_fungi_sp_known, "Phylum", "Class", "Order",
    nb_seq = FALSE, log10trans = FALSE
  )
}
}
}
\author{
Adrien Taudière
}
