% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{subset_taxa_pq}
\alias{subset_taxa_pq}
\title{Subset taxa using a conditional named boolean vector.}
\usage{
subset_taxa_pq(
  physeq,
  condition,
  verbose = TRUE,
  clean_pq = TRUE,
  taxa_names_from_physeq = FALSE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{condition}{A named boolean vector to subset taxa. Length must fit
the number of taxa and names must match taxa_names. Can also be a
condition using a column of the tax_table slot (see examples). If
the order of condition is the same as taxa_names(physeq),
you can use the parameter \code{taxa_names_from_physeq = TRUE}.}

\item{verbose}{(logical) Informations are printed}

\item{clean_pq}{(logical)
If set to TRUE, empty samples are discarded after subsetting ASV}

\item{taxa_names_from_physeq}{(logical) If set to TRUE, rename the
condition vector using taxa_names(physeq). Carefully check the result
of this function if you use this parameter. No effect if the condition
is of class \code{tax_table}.}
}
\value{
a new phyloseq object
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


The main objective of this function is to complete the
\code{\link[phyloseq:subset_taxa-methods]{phyloseq::subset_taxa()}} function by propose a more easy way of
subset_taxa using a named boolean vector. Names must match taxa_names.
}
\examples{

subset_taxa_pq(data_fungi, data_fungi@tax_table[, "Phylum"] == "Ascomycota")

cond_taxa <- grepl("Endophyte", data_fungi@tax_table[, "Guild"])
names(cond_taxa) <- taxa_names(data_fungi)
subset_taxa_pq(data_fungi, cond_taxa)

subset_taxa_pq(data_fungi, grepl("mycor", data_fungi@tax_table[, "Guild"]),
  taxa_names_from_physeq = TRUE
)

}
