% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{adonis_pq}
\alias{adonis_pq}
\title{Permanova on a phyloseq object}
\usage{
adonis_pq(
  physeq,
  formula,
  dist_method = "bray",
  merge_sample_by = NULL,
  na_remove = FALSE,
  correction_for_sample_size = FALSE,
  rarefy_nb_seqs = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{formula}{(required) the right part of a formula for \code{\link[vegan:adonis]{vegan::adonis2()}}.
Variables must be present in the \code{physeq@sam_data} slot.}

\item{dist_method}{(default "bray") the distance used. See
\code{\link[phyloseq:distance]{phyloseq::distance()}} for all available distances or run
\code{\link[phyloseq:distanceMethodList]{phyloseq::distanceMethodList()}}.
For aitchison and robust.aitchison distance, \code{\link[vegan:vegdist]{vegan::vegdist()}}
function is directly used.}

\item{merge_sample_by}{a vector to determine
which samples to merge using the \code{\link[=merge_samples2]{merge_samples2()}}
function. Need to be in \code{physeq@sam_data}}

\item{na_remove}{(logical, default FALSE) If set to TRUE, remove samples with
NA in the variables set in formula.}

\item{correction_for_sample_size}{(logical, default FALSE) If set to TRUE,
the sample size (number of sequences by samples) is added to formula in
the form \code{y~Library_Size + Biological_Effect} following recommendation of
\href{https://microbiomejournal.biomedcentral.com/articles/10.1186/s40168-017-0237-y}{Weiss et al. 2017}.
\code{correction_for_sample_size} overcome \code{rarefy_nb_seqs} if both are TRUE.}

\item{rarefy_nb_seqs}{(logical, default FALSE) Rarefy each sample
(before merging if merge_sample_by is set) using
\code{phyloseq::rarefy_even_depth()}.
if \code{correction_for_sample_size} is TRUE, rarefy_nb_seqs will have no
effect.}

\item{verbose}{(logical, default TRUE) If TRUE, prompt some messages.}

\item{...}{Other arguments passed on to \code{\link[vegan:adonis]{vegan::adonis2()}} function.
Note that the parameter \code{by} is important. If by is set to NULL
(default) the p-value is computed for the entire model.
by = NULL will assess the overall significance of all terms together,
by = "terms" will assess significance for each term (sequentially from first to last),
setting by = "margin" will assess the marginal effects of the terms (each marginal term analysed in a model with all other variables),
by = "onedf" will analyse one-degree-of-freedom contrasts sequentially. The argument is passed on to anova.cca.}
}
\value{
The function returns an anova.cca result object with a
new column for partial R^2. See help of \code{\link[vegan:adonis]{vegan::adonis2()}} for
more information.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


A wrapper for the \code{\link[vegan:adonis]{vegan::adonis2()}} function in the case of \code{physeq} object.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{vegan::adonis2()} if you
use this function.
}
\examples{
data(enterotype)
\donttest{
adonis_pq(enterotype, "SeqTech*Enterotype", na_remove = TRUE)
adonis_pq(enterotype, "SeqTech*Enterotype", na_remove = TRUE, by = "terms")
adonis_pq(enterotype, "SeqTech*Enterotype", na_remove = TRUE, by = "onedf")
adonis_pq(enterotype, "SeqTech*Enterotype", na_remove = TRUE, by = "margin")

adonis_pq(enterotype, "SeqTech", dist_method = "jaccard", by = "terms")
adonis_pq(enterotype, "SeqTech", dist_method = "robust.aitchison", by = "terms")
}
}
\author{
Adrien Taudière
}
