% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{signif_ancombc}
\alias{signif_ancombc}
\title{Filter ancombc_pq results}
\usage{
signif_ancombc(
  ancombc_res,
  filter_passed = TRUE,
  filter_diff = TRUE,
  min_abs_lfc = 0
)
}
\arguments{
\item{ancombc_res}{(required) the result of the ancombc_pq function
For the moment only bimodal factors are possible.}

\item{filter_passed}{(logical, default TRUE) Do we filter using the column
passed_ss? The passed_ss value is  TRUE if the taxon passed the sensitivity
analysis, i.e., adding different pseudo-counts to 0s would not change the results.}

\item{filter_diff}{(logical, default TRUE) Do we filter using the column
diff? The diff value is TRUE if the taxon is significant
(has q less than alpha)}

\item{min_abs_lfc}{(integer, default0) Minimum absolute value to filter
results based on Log Fold Change. For ex. a value of 1 filter out taxa
for which the abundance in a given level of the modality is not at least
the double of the abundance in the other level.}
}
\value{
A data.frame with the same number of columns than the \code{ancombc_res}
param but with less (or equal) numbers of rows
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Internally used in \code{\link[=plot_ancombc_pq]{plot_ancombc_pq()}}.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{ANCOMBC::ancombc2()} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("mia")) {
  data_fungi_mini@tax_table <- phyloseq::tax_table(cbind(
    data_fungi_mini@tax_table,
    "taxon" = taxa_names(data_fungi_mini)
  ))

  res_time <- ancombc_pq(
    data_fungi_mini,
    fact = "Time",
    levels_fact = c("0", "15"),
    tax_level = "taxon",
    verbose = TRUE
  )

  signif_ancombc(res_time)
}
}
}
\seealso{
\code{\link[=ancombc_pq]{ancombc_pq()}}, \code{\link[=plot_ancombc_pq]{plot_ancombc_pq()}}
}
