% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{var_par_rarperm_pq}
\alias{var_par_rarperm_pq}
\title{Partition the Variation of a phyloseq object with rarefaction permutations}
\usage{
var_par_rarperm_pq(
  physeq,
  list_component,
  dist_method = "bray",
  nperm = 99,
  quantile_prob = 0.975,
  dbrda_computation = FALSE,
  dbrda_signif_pval = 0.05,
  sample.size = min(sample_sums(physeq)),
  verbose = FALSE,
  progress_bar = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{list_component}{(required) A named list of 2, 3 or four vectors with
names from the \verb{@sam_data} slot.}

\item{dist_method}{(default "bray") the distance used. See
\code{\link[phyloseq:distance]{phyloseq::distance()}} for all available distances or run
\code{\link[phyloseq:distanceMethodList]{phyloseq::distanceMethodList()}}.
For aitchison and robust.aitchison distance, \code{\link[vegan:vegdist]{vegan::vegdist()}}
function is directly used.#' @param fill_bg}

\item{nperm}{(int) The number of permutations to perform.}

\item{quantile_prob}{(float, \verb{[0:1]}) the value to compute the quantile.
Minimum quantile is compute using 1-quantile_prob.}

\item{dbrda_computation}{(logical) Do dbrda computations are runned for each
individual component (each name of the list component) ?}

\item{dbrda_signif_pval}{(float, \verb{[0:1]}) The value under which the dbrda is
considered significant.}

\item{sample.size}{(int) A single integer value equal to the number of
reads being simulated, also known as the depth. See
\code{\link[phyloseq:rarefy_even_depth]{phyloseq::rarefy_even_depth()}}.}

\item{verbose}{(logical). If TRUE, print additional information.}

\item{progress_bar}{(logical, default TRUE) Do we print progress during
the calculation?}
}
\value{
A list of class varpart with additional information in the
\verb{$part$indfract} part. Adj.R.square is the mean across permutation.
Adj.R.squared_quantil_min and Adj.R.squared_quantil_max represent
the quantile values of adjusted R squared
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


This is an extension of the function \code{\link[=var_par_pq]{var_par_pq()}}. The main addition is
the computation of nperm permutations with rarefaction even depth by
sample. The return object
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{vegan::varpart()} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("vegan")) {
  data_fungi_woNA <- subset_samples(data_fungi, !is.na(Time) & !is.na(Height))
  res_var_9 <- var_par_rarperm_pq(
    data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    nperm = 9,
    dbrda_computation = TRUE
  )
  res_var_2 <- var_par_rarperm_pq(
    data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    nperm = 2,
    dbrda_computation = TRUE
  )
}
}
}
\seealso{
\code{\link[=var_par_pq]{var_par_pq()}}, \code{\link[vegan:varpart]{vegan::varpart()}}, \code{\link[=plot_var_part_pq]{plot_var_part_pq()}}
}
\author{
Adrien Taudière
}
