% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_tax_pq}
\alias{plot_tax_pq}
\title{Plot taxonomic distribution in function of a factor with stacked bar in \%}
\usage{
plot_tax_pq(
  physeq,
  fact = NULL,
  merge_sample_by = NULL,
  type = "nb_seq",
  taxa_fill = "Order",
  print_values = TRUE,
  color_border = "lightgrey",
  linewidth = 0.1,
  prop_print_value = 0.01,
  nb_print_value = NULL,
  add_info = TRUE,
  na_remove = TRUE,
  clean_pq = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{merge_sample_by}{a vector to determine
which samples to merge using the
\code{\link[=merge_samples2]{merge_samples2()}} function.
Need to be in \code{physeq@sam_data}}

\item{type}{If "nb_seq" (default), the number of sequences is
used in plot. If "nb_asv", the number of ASV is plotted. If both,
return a list of two plots, one for nbSeq and one for ASV.}

\item{taxa_fill}{(default: 'Order'): Name of the taxonomic rank of interest}

\item{print_values}{(logical, default TRUE): Do we print some values on plot?}

\item{color_border}{color for the border}

\item{linewidth}{The line width of geom_bar}

\item{prop_print_value}{minimal proportion to print value (default 0.01)}

\item{nb_print_value}{number of higher values to print
(replace prop_print_value if both are set).}

\item{add_info}{(logical, default TRUE) Do we add title and subtitle with
information about the total number of sequences and the number of samples
per modality.}

\item{na_remove}{(logical, default TRUE) if TRUE remove all the samples
with NA in the \code{split_by} variable of the \code{physeq@sam_data} slot}

\item{clean_pq}{(logical)
If set to TRUE, empty samples are discarded after subsetting ASV}
}
\value{
A ggplot2 graphic
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

An alternative to \code{phyloseq::plot_bar()} function.
}
\examples{
data(data_fungi_sp_known)
plot_tax_pq(data_fungi_sp_known,
  "Time",
  merge_sample_by = "Time",
  taxa_fill = "Class"
)
\donttest{
plot_tax_pq(data_fungi_sp_known,
  "Height",
  merge_sample_by = "Height",
  taxa_fill = "Class",
  na_remove = TRUE,
  color_border = rgb(0, 0, 0, 0)
)

plot_tax_pq(data_fungi_sp_known,
  "Height",
  merge_sample_by = "Height",
  taxa_fill = "Class",
  na_remove = FALSE,
  clean_pq = FALSE
)
}
}
\seealso{
\code{\link[=tax_bar_pq]{tax_bar_pq()}} and \code{\link[=multitax_bar_pq]{multitax_bar_pq()}}
}
\author{
Adrien Taudière
}
