% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deseq2_edgeR.R
\name{phyloseq_to_edgeR}
\alias{phyloseq_to_edgeR}
\title{Convert phyloseq OTU count data into DGEList for edgeR package}
\usage{
phyloseq_to_edgeR(physeq, group, method = "RLE", ...)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{group}{(required) A character vector or factor giving the experimental
group/condition for each sample/library. Alternatively, you may provide
the name of a sample variable. This name should be among the output of
\code{sample_variables(physeq)}, in which case
\code{get_variable(physeq, group)} would return either a character vector or
factor.
This is passed on to \code{\link[edgeR]{DGEList}},
and you may find further details or examples in its documentation.}

\item{method}{The label of the edgeR-implemented normalization
to use.
See \code{\link[edgeR]{calcNormFactors}} for supported options and details.
The default option is \code{"RLE"}, which is a scaling factor method
proposed by Anders and Huber (2010).
At time of writing, the \link[edgeR]{edgeR} package supported
the following options to the \code{method} argument:

\code{c("TMM", "RLE", "upperquartile", "none")}.}

\item{...}{Additional arguments passed on to \code{\link[edgeR]{DGEList}}}
}
\value{
A DGEList object. See \code{\link[edgeR:estimateTagwiseDisp]{edgeR::estimateTagwiseDisp()}} for more details.
}
\description{
Convert phyloseq OTU count data into DGEList for edgeR package
}
