% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{plot_ancombc_pq}
\alias{plot_ancombc_pq}
\title{Plot ANCOMBC2 result for phyloseq object}
\usage{
plot_ancombc_pq(
  physeq,
  ancombc_res,
  filter_passed = TRUE,
  filter_diff = TRUE,
  min_abs_lfc = 0,
  tax_col = "Genus",
  tax_label = "Species",
  add_marginal_vioplot = TRUE,
  add_label = TRUE,
  add_hline_cut_lfc = NULL
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{ancombc_res}{(required) the result of the ancombc_pq function
For the moment only bimodal factors are possible.}

\item{filter_passed}{(logical, default TRUE) Do we filter using the column
passed_ss? The passed_ss value is  TRUE if the taxon passed the sensitivity
analysis, i.e., adding different pseudo-counts to 0s would not change the results.}

\item{filter_diff}{(logical, default TRUE) Do we filter using the column
diff? The diff value is TRUE if the taxon is significant
(has q less than alpha)}

\item{min_abs_lfc}{(integer, default 0) Minimum absolute value to filter
results based on Log Fold Change. For ex. a value of 1 filter out taxa
for which the abundance in a given level of the modalty is not at least
the double of the abundance in the other level.}

\item{tax_col}{The taxonomic level (must be present in \code{tax_table} slot)
to color the points}

\item{tax_label}{The taxonomic level (must be present in \code{tax_table} slot)
to add label}

\item{add_marginal_vioplot}{(logical, default TRUE) Do we add a marginal
vioplot representing all the taxa lfc from ancombc_res.}

\item{add_label}{(logical, default TRUE) Do we add a label?}

\item{add_hline_cut_lfc}{(logical, default NULL) Do we add two horizontal
lines when min_abs_lfc is set (different from zero)?}
}
\value{
A ggplot2 object. If add_marginal_vioplot is TRUE, this is a
patchworks of plot made using \code{patchwork::plot_layout()}.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Graphical representation of ANCOMBC2 result.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{ANCOMBC::ancombc2()} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("mia")) {
  data_fungi_mini@tax_table <- phyloseq::tax_table(cbind(
    data_fungi_mini@tax_table,
    "taxon" = taxa_names(data_fungi_mini)
  ))

  res_time <- ancombc_pq(
    data_fungi_mini,
    fact = "Time",
    levels_fact = c("0", "15"),
    tax_level = "taxon",
    verbose = TRUE
  )

  plot_ancombc_pq(data_fungi_mini, res_time,
    filter_passed = FALSE,
    tax_label = "Genus", tax_col = "Order"
  )
  plot_ancombc_pq(data_fungi_mini, res_time, tax_col = "Genus")
  plot_ancombc_pq(data_fungi_mini, res_time,
    filter_passed = FALSE,
    filter_diff = FALSE, tax_col = "Family", add_label = FALSE
  )
}
}
}
\author{
Adrien Taudière
}
