% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterDiagGaussian.R
\name{clusterDiagGaussian}
\alias{clusterDiagGaussian}
\title{Create an instance of the [\code{\linkS4class{ClusterDiagGaussian}}] class}
\usage{
clusterDiagGaussian(data, nbCluster = 2,
  modelNames = clusterDiagGaussianNames(), strategy = clusterFastStrategy(),
  criterion = "ICL", nbCore = 1)
}
\arguments{
\item{data}{frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables. If the data set contains NA values, they
will be estimated during the estimation process.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{modelNames}{[\code{\link{vector}}] of model names to run. By default all diagonal
Gaussian models are estimated. All the model names are given by the method
[\code{\link{clusterDiagGaussianNames}}].}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. clusterStrategy() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL". Default is "ICL".}

\item{nbCore}{integer defining the number of processor to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterDiagGaussian}}] class.
}
\description{
This function computes the optimal diagonal Gaussian mixture model according
to the [\code{criterion}] among the list of model given in [\code{modelNames}]
and the number of clusters given in [\code{nbCluster}], using the strategy specified in [\code{strategy}].
}
\examples{
## A quantitative example with the famous geyser data set
data(geyser)
## add 10 missing values as random
x = as.matrix(geyser); n <- nrow(x); p <- ncol(x);
indexes <- matrix(c(round(runif(5,1,n)), round(runif(5,1,p))), ncol=2);
x[indexes] <- NA;
## estimate model (using fast strategy, results may be misleading)
model <- clusterDiagGaussian(data=x, nbCluster=2:3, strategy = clusterFastStrategy())

## use graphics functions
\dontrun{
plot(model)
}

## get summary
summary(model)
## print model
\dontrun{
print(model)
}
## get estimated missing values
missingValues(model)
}
\author{
Serge Iovleff
}

