% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModelNames.R
\name{clusterDiagGaussianNames}
\alias{clusterDiagGaussianNames}
\alias{clusterValidDiagGaussianNames}
\title{Create a vector of diagonal Gaussian mixture model names.}
\usage{
clusterDiagGaussianNames(prop = "all", sdInCluster = "all",
  sdBetweenCluster = "all")

clusterValidDiagGaussianNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{sdInCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{sdBetweenCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{names}{a vector of character}
}
\value{
A vector of character with the model names.
}
\description{
In a diagonal Gaussian mixture model, we assume that the variance
matrices are diagonal in each cluster. Assumptions on the proportions
and standard deviations give rise to 8 models:
\enumerate{
 \item {The proportions can be equal or free.}
 \item {The standard deviations can be equal or free for all the variables.}
 \item {The standard deviations can be equal or free for all the clusters.}
}
}
\details{
The model names are summarized in the following array:
\tabular{llll}{
 Model Name      \tab Proportions \tab s.d. in variables \tab s.d. in clusters \cr
 gaussian_p_sjk  \tab Equal       \tab Free              \tab Free  \cr
 gaussian_p_sj   \tab Equal       \tab Free              \tab Equal \cr
 gaussian_p_sk   \tab Equal       \tab Equal             \tab Free  \cr
 gaussian_p_s    \tab Equal       \tab Equal             \tab Equal \cr
 gaussian_pk_sjk \tab Free        \tab Free              \tab Free  \cr
 gaussian_pk_sj  \tab Free        \tab Free              \tab Equal \cr
 gaussian_pk_sk  \tab Free        \tab Equal             \tab Free  \cr
 gaussian_pk_s   \tab Free        \tab Equal             \tab Equal \cr
}
}
\examples{
clusterDiagGaussianNames()
## same as c("gaussian_p_sk", "gaussian_pk_sk")
clusterDiagGaussianNames(prop="all", sdInCluster="equal", sdBetweenCluster= "free")

}
